function [field_names field_values]=testsgetfields(md,sequence),
%TESTSGETFIELDS - build the fields to be checked from a analysis
%
%   This routine is used by nightly runs (runme.m and updatearchive.m).
%   for an input analysis 'prognostic', it will output 'prognostic.thickness'
%
%   Usage:
%      [field_names field_values]=testsgetfields(md,analysis)
%
%   Example:
%      [field_names field_values]=testsgetfields(md,'DiagnosticSolution')
%
%   See also: TESTSGETANALYSIS, TESTGETPACKAGE

%recover what is being requested.
analysis_type=sequence{1};
sub_analysis_type=sequence{2};
qmu=sequence{3};
control=sequence{4};
control_fit=sequence{5};
parallel=sequence{6};

if (analysis_type==DiagnosticSolutionEnum),
	if control,
		field_names={'Vel','J','parameter'};
		vel=zeros(md.numberofgrids,1);
		vel(md.results.DiagnosticAnalysis.Vel.index)=md.results.DiagnosticAnalysis.Vel.value;
		j=zeros(md.numberofgrids,1);
		j(md.results.DiagnosticAnalysis.J.index)=md.results.DiagnosticAnalysis.J.value;
		parameter=zeros(md.numberofgrids,1);
		parameter(md.results.DiagnosticAnalysis.parameter.index)=md.results.DiagnosticAnalysis.parameter.value;
		field_values={vel,j,parameter};
	elseif qmu,
		fields={'dakota.importancefactors'};
	else
		if md.dim==3
			field_names={'Vy','Vz'};
			vy=zeros(md.numberofgrids,1);
			vy(md.results.DiagnosticAnalysis.Vy.index)=md.results.DiagnosticAnalysis.Vy.value;
			vz=zeros(md.numberofgrids,1);
			vz(md.results.DiagnosticAnalysis.Vz.index)=md.results.DiagnosticAnalysis.Vz.value;
			field_values={vy,vz};
		else
			field_names={'Vel'};
			vel=zeros(md.numberofgrids,1);
			vel(md.results.DiagnosticAnalysis.Vel.index)=md.results.DiagnosticAnalysis.Vel.value;
			field_values={vel};
		end
	end

elseif (analysis_type==ThermalSolutionEnum),
	field_names={'Temperature','Melting'};
	temperature=zeros(md.numberofgrids,1);
	temperature(md.results.ThermalAnalysis(end).Temperature.index)=md.results.ThermalAnalysis(end).Temperature.value;
	melting=zeros(md.numberofgrids,1);
	melting(md.results.ThermalAnalysis(end).Melting.index)=md.results.ThermalAnalysis(end).Melting.value;
	field_values={temperature,melting};

elseif (analysis_type==PrognosticSolutionEnum),
	field_names={'Thickness'};
	thickness=zeros(md.numberofgrids,1);
	thickness(md.results.PrognosticAnalysis.Thickness.index)=md.results.PrognosticAnalysis.Thickness.value;
	field_values={thickness};

elseif (analysis_type==Prognostic2SolutionEnum),
	field_names={'Thickness'};
	thickness=zeros(md.numberofgrids,1);
	thickness(md.results.Prognostic2Analysis.Thickness.index)=md.results.Prognostic2Analysis.Thickness.value;
	field_values={thickness};

elseif (analysis_type==Transient2DSolutionEnum), 
	field_names={'Vel','Thickness','Surface','Bed'};
	vel=zeros(md.numberofgrids,1);
	vel(md.results.Transient2DAnalysis(end).Vel.index)=md.results.Transient2DAnalysis(end).Vel.value;
	thickness=zeros(md.numberofgrids,1);
	thickness(md.results.Transient2DAnalysis(end).Thickness.index)=md.results.Transient2DAnalysis(end).Thickness.value;
	surface=zeros(md.numberofgrids,1);
	surface(md.results.Transient2DAnalysis(end).Surface.index)=md.results.Transient2DAnalysis(end).Surface.value;
	bed=zeros(md.numberofgrids,1);
	bed(md.results.Transient2DAnalysis(end).Bed.index)=md.results.Transient2DAnalysis(end).Bed.value;
	field_values={vel,thickness,surface,bed};

elseif (analysis_type==Transient3DSolutionEnum), 
	field_names={'Vel','Pressure','Temperature','Melting','Thickness','Surface','Bed'};
	vel=zeros(md.numberofgrids,1);
	vel(md.results.Transient3DAnalysis(end).Vel.index)=md.results.Transient3DAnalysis(end).Vel.value;
	pressure=zeros(md.numberofgrids,1);
	pressure(md.results.Transient3DAnalysis(end).Pressure.index)=md.results.Transient3DAnalysis(end).Pressure.value;
	temperature=zeros(md.numberofgrids,1);
	temperature(md.results.Transient3DAnalysis(end).Temperature.index)=md.results.Transient3DAnalysis(end).Temperature.value;
	melting=zeros(md.numberofgrids,1);
	melting(md.results.Transient3DAnalysis(end).Melting.index)=md.results.Transient3DAnalysis(end).Melting.value;
	thickness=zeros(md.numberofgrids,1);
	thickness(md.results.Transient3DAnalysis(end).Thickness.index)=md.results.Transient3DAnalysis(end).Thickness.value;
	surface=zeros(md.numberofgrids,1);
	surface(md.results.Transient3DAnalysis(end).Surface.index)=md.results.Transient3DAnalysis(end).Surface.value;
	bed=zeros(md.numberofgrids,1);
	bed(md.results.Transient3DAnalysis(end).Bed.index)=md.results.Transient3DAnalysis(end).Bed.value;
	field_values={vel,pressure,temperature,melting,thickness,surface,bed};

elseif (analysis_type==SteadystateSolutionEnum), 
	if control,
		field_names={'Vel','J','parameter'};
		vel=zeros(md.numberofgrids,1);
		vel(md.results.SteadystateAnalysis.Vel.index)=md.results.SteadystateAnalysis.Vel.value;
		j=zeros(md.numberofgrids,1);
		j(md.results.SteadystateAnalysis.J.index)=md.results.SteadystateAnalysis.J.value;
		parameter=zeros(md.numberofgrids,1);
		parameter(md.results.SteadystateAnalysis.parameter.index)=md.results.SteadystateAnalysis.parameter.value;
		field_values={vel,j,parameter};
	else
		field_names={'Vel','Pressure','Temperature'};
		vel=zeros(md.numberofgrids,1);
		vel(md.results.SteadystateAnalysis.Vel.index)=md.results.SteadystateAnalysis.Vel.value;
		presure=zeros(md.numberofgrids,1);
		presure(md.results.SteadystateAnalysis.Pressure.index)=md.results.SteadystateAnalysis.Pressure.value;
		temperature=zeros(md.numberofgrids,1);
		temperature(md.results.SteadystateAnalysis.Temperature.index)=md.results.SteadystateAnalysis.Temperature.value;
		field_values={vel,pressure,temperature};
	end

elseif (analysis_type==BalancedthicknessSolutionEnum), 
	field_names={'Thickness'};
	thickness=zeros(md.numberofgrids,1);
	thickness(md.results.BalancedthicknessAnalysis.Thickness.index)=md.results.BalancedthicknessAnalysis.Thickness.value;
	field_values={thickness};

elseif (analysis_type==SurfaceSlopeSolutionEnum), 
	field_names={'Slopex','Slopey'};
	slopex=zeros(md.numberofgrids,1);
	slopex(md.results.DiagnosticAnalysis.Slopex.index)=md.results.DiagnosticAnalysis.Slopex.value;
	slopey=zeros(md.numberofgrids,1);
	slopey(md.results.DiagnosticAnalysis.Slopey.index)=md.results.DiagnosticAnalysis.Slopey.value;
	field_values={slopex,slopey};

elseif (analysis_type==BedSlopeSolutionEnum), 
	field_names={'Slopex','Slopey'};
	slopex=zeros(md.numberofgrids,1);
	slopex(md.results.DiagnosticAnalysis.Slopex.index)=md.results.DiagnosticAnalysis.Slopex.value;
	slopey=zeros(md.numberofgrids,1);
	slopey(md.results.DiagnosticAnalysis.Slopey.index)=md.results.DiagnosticAnalysis.Slopey.value;
	field_values={slopex,slopey};

else
	error(['testsgetfields error message: requested sequence not supported yet']);
end
