/*!\file: bedslope_core.cpp
 * \brief: core of the slope solution 
 */ 

#include "./solutions.h"
#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void bedslope_core(FemModel* femmodel){

	/*parameters: */
	int  verbose;
	int  dim;
	bool isstokes;
	bool ishutter;
	int  solution_type;

	/*Recover some parameters: */
	femmodel->parameters->FindParam(&verbose,VerboseEnum);
	femmodel->parameters->FindParam(&dim,DimEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	if(verbose)_printf_("%s\n","computing slope...");

	/*Call on core computations: */
	femmodel->SetCurrentAnalysisAlias(SlopeAnalysisEnum,BedSlopeXAnalysisEnum);
	solver_linear(NULL,femmodel);
	femmodel->SetCurrentAnalysisAlias(SlopeAnalysisEnum,BedSlopeYAnalysisEnum);
	solver_linear(NULL,femmodel);
	
	/*extrude inputs if we are in 3D: */
	if (dim==3){
		if(verbose)_printf_("%s\n","extruding bed in 3d...");
		InputExtrudex(femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters,BedSlopeXEnum);
		InputExtrudex(femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters,BedSlopeYEnum);
	}
	
	if(verbose)_printf_("saving results:\n");
	if(solution_type==BedSlopeAnalysisEnum){
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,BedSlopeXEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,BedSlopeYEnum);
	}

}
