function structure=ProcessPatch(structure,step,Patch);
%PROCESSPATCH - create a structure from a patch
%
%   Usage:
%      Result=ProcessPatch(Patch);

%Get number of fields;
fields=unique(Patch(:,1));
steps=unique(Patch(:,2));

%parse steps
for j=1:length(steps),

	posstep=find(Patch(:,2)==steps(j));
	
	%Take all the lines of the Patch for this timestep
	temporarypatch=Patch(posstep,:);
	time=temporarypatch(1,3);
	step=temporarypatch(1,2);

	%parse fields
	for i=1:length(fields),

		%get name
		fieldname=EnumAsString(fields(i));

		%get line positions
		pos=find(temporarypatch(:,1)==fields(i));

		%Fill Result structure
		structure(step).(fieldname).steps=step;
		structure(step).(fieldname).time=time;
		structure(step).(fieldname).element=temporarypatch(pos,4);
		structure(step).(fieldname).interpolation=temporarypatch(pos,5);
		structure(step).(fieldname).index=temporarypatch(pos,6:8);
		structure(step).(fieldname).value=temporarypatch(pos,9:end);

	end
end
