function [field_names field_values]=testsgetfields(md,sequence),
%TESTSGETFIELDS - build the fields to be checked from a analysis
%
%   This routine is used by nightly runs (runme.m and updatearchive.m).
%   for an input analysis 'prognostic', it will output 'prognostic.thickness'
%
%   Usage:
%      [field_names field_values]=testsgetfields(md,analysis)
%
%   Example:
%      [field_names field_values]=testsgetfields(md,'DiagnosticSolution')
%
%   See also: TESTSGETANALYSIS, TESTGETPACKAGE

%recover what is being requested.
analysis_type=sequence{1};
sub_analysis_type=sequence{2};
qmu=sequence{3};
control=sequence{4};
control_fit=sequence{5};
parallel=sequence{6};

if (analysis_type==DiagnosticSolutionEnum),
	if control,
		fields={,'DiagnosticAnalysis.Vel.value','DiagnosticAnalysis.J.value','DiagnosticAnalysis.parameter.value'};
	elseif qmu,
		fields={'dakota.importancefactors'};
	else
		if md.dim==3
			fields={'DiagnosticAnalysis.Vy.value','DiagnosticAnalysis.Vz.value'};
		else
			field_names={'Vel'};
			vel=zeros(md.numberofgrids,1);
			vel(md.results.DiagnosticAnalysis.Vel.index)=md.results.DiagnosticAnalysis.Vel.value;
			field_values={vel};
		end
	end

elseif (analysis_type==ThermalSolutionEnum),
	fields={'ThermalSolution(end).temperature','ThermalSolution(end).melting'};

elseif (analysis_type==PrognosticSolutionEnum),
	field_names={'Thickness'};
	thickness=zeros(md.numberofgrids,1);
	thickness(md.results.PrognosticAnalysis.Thickness.index)=md.results.PrognosticAnalysis.Thickness.value;
	field_values={thickness};

elseif (analysis_type==Prognostic2SolutionEnum),
	fields={'Prognostic2Solution.thickness'};

elseif (analysis_type==Transient2DSolutionEnum), 
	fields={'TransientSolution(end).vel','TransientSolution(end).thickness','TransientSolution(end).surface','TransientSolution(end).bed'};

elseif (analysis_type==Transient3DSolutionEnum), 
	fields={'TransientSolution(end).vel','TransientSolution(end).pressure','TransientSolution(end).temperature','TransientSolution(end).melting','TransientSolution(end).thickness','TransientSolution(end).surface','TransientSolution(end).bed'};

elseif (analysis_type==SteadystateSolutionEnum), 
	if control,
		fields={'SteadystateSolution.vel','SteadystateSolution.J','SteadystateSolution.parameter'};
	else
		fields={'SteadystateSolution.vel','SteadystateSolution.pressure','SteadystateSolution.temperature'};
	end

elseif (analysis_type==BalancedthicknessSolutionEnum), 
	field_names={'Thickness'};
	thickness=zeros(md.numberofgrids,1);
	thickness(md.results.BalancedthicknessAnalysis.Thickness.index)=md.results.BalancedthicknessAnalysis.Thickness.value;
	field_values={thickness};

elseif (analysis_type==SlopeSolutionEnum), 
	fields={'SlopeSolution.slopex','SlopeSolution.slopey'};

else
	error(['testsgetfields error message: requested sequence not supported yet']);
end
