function [field_names field_values]=testsgetfields(md,sequence),
%TESTSGETFIELDS - build the fields to be checked from a analysis
%
%   This routine is used by nightly runs (runme.m and updatearchive.m).
%   for an input analysis 'prognostic', it will output 'prognostic.thickness'
%
%   Usage:
%      fields=testsgetfields(md,analysis)
%
%   Example:
%      fields=testsgetfields(md,'DiagnosticSolution')
%
%   See also: TESTSGETANALYSIS, TESTGETPACKAGE

%recover what is being requested.
analysis_type=sequence{1};
sub_analysis_type=sequence{2};
qmu=sequence{3};
control=sequence{4};
control_fit=sequence{5};
parallel=sequence{6};

if (analysis_type==DiagnosticSolutionEnum),
	if control,
		fields={,'DiagnosticAnalysis.Vel.value','DiagnosticAnalysis.J.value','DiagnosticAnalysis.parameter.value'};
	elseif qmu,
		fields={'dakota.importancefactors'};
	else
		if md.dim==3
			fields={'DiagnosticAnalysis.Vy.value','DiagnosticAnalysis.Vz.value'};
		else
			field_names={'Vel'};
			vx=zeros(md.numberofgrids,1);
			vx(md.results.DiagnosticAnalysis.Vx.index)=md.results.DiagnosticAnalysis.Vx.value;
			vy=zeros(md.numberofgrids,1);
			vy(md.results.DiagnosticAnalysis.Vy.index)=md.results.DiagnosticAnalysis.Vy.value;
			vel=sqrt(vx.^2+vy.^2);
			field_values={vel};
		end
	end
	md.results.DiagnosticAnalysis.Vx.value

elseif (analysis_type==ThermalSolutionEnum),
	fields={'ThermalSolution(end).temperature','ThermalSolution(end).melting'};

elseif (analysis_type==PrognosticSolutionEnum),
	fields={'PrognosticSolution.thickness'};

elseif (analysis_type==Prognostic2SolutionEnum),
	fields={'Prognostic2Solution.thickness'};

elseif (analysis_type==TransientSolutionEnum), 
	if md.dim==3
		fields={'TransientSolution(end).vel','TransientSolution(end).pressure','TransientSolution(end).temperature','TransientSolution(end).melting','TransientSolution(end).thickness','TransientSolution(end).surface','TransientSolution(end).bed'};
	else
		fields={'TransientSolution(end).vel','TransientSolution(end).thickness','TransientSolution(end).surface','TransientSolution(end).bed'};
	end

elseif (analysis_type==SteadystateSolutionEnum), 
	if control,
		fields={'SteadystateSolution.vel','SteadystateSolution.J','SteadystateSolution.parameter'};
	else
		fields={'SteadystateSolution.vel','SteadystateSolution.pressure','SteadystateSolution.temperature'};
	end

elseif (analysis_type==BalancedthicknessSolutionEnum), 
	fields={'BalancedthicknessSolution.thickness'};

elseif (analysis_type==SlopecomputeSolutionEnum), 
	fields={'SlopecomputeSolution.slopex','SlopecomputeSolution.slopey'};

else
	error(['testsgetfields error message: requested sequence not supported yet']);
end
