%  --  startup --
startup;
system('ln -s $ISSM_DIR/startup.m .'); startup;
%  --  vim --
!vim configuration.m
!vim runme.m
%  --  tests  --
md=runme('analysis_type',DiagnosticSolutionEnum);
md=runme('analysis_type',DiagnosticSolutionEnum,'parallel',1);
runme('analysis_type',[DiagnosticSolutionEnum]);
%  --  tweak parameters --
md.numberofelements
md.numberofgrids
%  --  model set up  --
md=model;
md=mesh(md,'DomainOutline.exp',5000);
md=geography(md,'','');
md=geography(md,'Iceshelves.exp','Islands.exp');
md=parameterize(md,'Antarctica.par');
md=extrude(md,8,1);
md=setelementstype(md,'pattyn','all','stokes','all');
md=setelementstype(md,'macayeal','all');
%  --  execution --
md=solve(md,'analysis_type',ThermalSolutionEnum,'batch','yes');
md=solve(md,'analysis_type',ThermalSolutionEnum);
md=solve(md,'analysis_type',DiagnosticSolutionEnum,'batch','yes');
md=solve(md,'analysis_type',DiagnosticSolutionEnum);
md=loadresultsfromcluster(md);
md=tres(md,ThermalSolutionEnum);
md=tres(md,DiagnosticSolutionEnum);
%  --  plots  --
plotmodel(md,'data','vel')
plotmodel(md,'data',md.results.diagnostic.vel)
