/*! \file StringParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _STRINGPARAM_H_
#define _STRINGPARAM_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif


#include "./Param.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class StringParam: public Param{

	private: 
		/*just hold 3 values for 3 vertices: */
		int enum_type;
		char* value;

	public:
		/*StringParam constructors, destructors: {{{1*/
		StringParam();
		StringParam(int enum_type,char* value);
		~StringParam();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Param vritual function definitions: {{{1*/
		int   EnumType(){return enum_type;}
		void  GetParameterValue(bool* pbool){ISSMERROR("String param of enum %i (%s) cannot return a bool",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(int* pinteger){ISSMERROR("String param of enum %i (%s) cannot return an integer",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(double* pdouble){ISSMERROR("String param of enum %i (%s) cannot return a double",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(char** pstring);
		void  GetParameterValue(char*** pstringarray,int* pM){ISSMERROR("String param of enum %i (%s) cannot return a string arrayl",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM){ISSMERROR("String param of enum %i (%s) cannot return a double array",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM, int* pN){ISSMERROR("String param of enum %i (%s) cannot return a double array",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(Vec* pvec){ISSMERROR("String param of enum %i (%s) cannot return a Vec",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(Mat* pmat){ISSMERROR("String param of enum %i (%s) cannot return a Mat",enum_type,EnumAsString(enum_type));}

		void  SetValue(bool boolean){ISSMERROR("String param of enum %i (%s) cannot hold a boolean",enum_type,EnumAsString(enum_type));}
		void  SetValue(int integer){ISSMERROR("String param of enum %i (%s) cannot hold an integer",enum_type,EnumAsString(enum_type));}
		void  SetValue(double scalar){ISSMERROR("String param of enum %i (%s) cannot hold a scalar",enum_type,EnumAsString(enum_type));}
		void  SetValue(char* string);
		void  SetValue(char** stringarray,int M){ISSMERROR("String param of enum %i (%s) cannot hold a string array",enum_type,EnumAsString(enum_type));}
		void  SetValue(double* doublearray,int M){ISSMERROR("String param of enum %i (%s) cannot hold a double array",enum_type,EnumAsString(enum_type));}
		void  SetValue(double* pdoublearray,int M,int N){ISSMERROR("String param of enum %i (%s) cannot hold a double array",enum_type,EnumAsString(enum_type));}
		void  SetValue(Vec vec){ISSMERROR("String param of enum %i (%s) cannot hold a Vec",enum_type,EnumAsString(enum_type));}
		void  SetValue(Mat mat){ISSMERROR("String param of enum %i (%s) cannot hold a Mat",enum_type,EnumAsString(enum_type));}

		char* GetParameterName(void);
		#ifdef _SERIAL_
		void  SetMatlabField(mxArray* dataref);
		#endif

		/*}}}*/
};
#endif  /* _STRINGPARAM_H */
