/*
 * Object.h:
 * \brief prototype for abstract Object class
 * \file Object.h
 * This prototype describes the Object class. This is an abstract class, parent 
 * to any other objects (Quad, Tria, Grid, etc ...), that can be included in a 
 * DataSet.
 */


#ifndef _OBJECT_H_
#define _OBJECT_H_

class Object {

	public: 

		virtual       ~Object() {};
		virtual void  Echo()=0;
		virtual void  DeepEcho()=0;
		virtual int   Id()=0;
		virtual int   MyRank()=0;
		virtual void  Marshall(char** pmarshalled_dataset)=0;
		virtual int   MarshallSize()=0;
		virtual void  Demarshall(char** pmarshalled_dataset)=0;
		virtual int   Enum()=0;
		virtual Object* copy()=0;

};
#endif
