/*!\file Matpar.h
 * \brief: header file for matpar object
 */

#ifndef _MATPAR_H_
#define _MATPAR_H_

/*Headers:*/
/*{{{1*/
#include "./Material.h"
class IoModel;
/*}}}*/

class Matpar: public Material{

	private: 
		int	mid;
		double	rho_ice; 
		double	rho_water;
		double  heatcapacity;
		double  thermalconductivity;
		double  latentheat;
		double  beta;
		double  meltingpoint;
		double  mixed_layer_capacity;
		double  thermal_exchange_velocity;
		double  g;

	public:

		Matpar();
	
		Matpar(int	mid, double	rho_ice, double	rho_water, double  heatcapacity, double  thermalconductivity, double  latentheat, double  beta, double  meltingpoint, double  mixed_layer_capacity, double  thermal_exchange_velocity, double  g);
		void Init(int	mid, double	rho_ice, double	rho_water, double  heatcapacity, double  thermalconductivity, double  latentheat, double  beta, double  meltingpoint, double  mixed_layer_capacity, double  thermal_exchange_velocity, double  g);
		Matpar(int matpar_id, IoModel* iomodel);
		~Matpar();

		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Update virtual functions resolution: {{{1*/
		void   InputUpdateFromVector(double* vector, int name, int type);
		void   InputUpdateFromVector(int* vector, int name, int type);
		void   InputUpdateFromVector(bool* vector, int name, int type);
		void   InputUpdateFromConstant(double constant, int name);
		void   InputUpdateFromConstant(int constant, int name);
		void   InputUpdateFromConstant(bool constant, int name);
		void   InputUpdateFromSolution(double* solution);
		/*}}}*/
		/*Numerics: {{{1*/
		double GetG();
		double GetRhoIce();
		double GetRhoWater();
		double GetMixedLayerCapacity();
		double GetThermalExchangeVelocity();
		double GetHeatCapacity();
		double GetThermalConductivity();
		double GetLatentHeat();
		double GetBeta();
		double GetMeltingPoint();
		/*}}}*/

};

#endif  /* _MATPAR_H_ */
