/*! \file Penta.h 
 *  \brief: header file for penta object
 */

#ifndef _PENTA_H
#define _PENTA_H

/*Headers:*/
/*{{{1*/
#include "./Element.h"
#include "./PentaHook.h"
class  Object;
class Parameters;
class Inputs;
class IoModel;
class Node;
class Matice;
class Matpar;

#include "../../shared/Exceptions/exceptions.h"
#include "../../include/include.h"

/*}}}*/

class Penta: public Element,public PentaHook{

	public:

		int          id;

		Node       **nodes;        // 6 nodes
		Matice      *matice;       // 1 material ice
		Matpar      *matpar;       // 1 material parameter
		Penta      **neighbors;   // 2 neighbors: first one under, second one above

		Parameters  *parameters;   //pointer to solution parameters
		Inputs      *inputs;
		Results      *results;

		/*internal parameters: */
		bool        *collapse; //collapse elements, depending on analysis_type

		/*Penta constructors and destructor: {{{1*/
		Penta();
		Penta(int penta_id,int i, IoModel* iomodel,int nummodels);
		void  Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type);
		void  UpdateGeometry(void);
		~Penta();
		/*}}}*/
		/*Object virtual functions definitions: {{{1*/
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Penta management: {{{1*/
		void  Configure(Elements* elements,Loads* loads,DataSet* nodes,Materials* materials,Parameters* parameters);
		bool  IsInput(int name);
		bool  IsOnSurface(void);
		Penta* GetUpperElement(void);
		void* SpawnSing(int g0);
		void* SpawnBeam(int g0, int g1);
		void* SpawnTria(int g0, int g1, int g2);
		void  SetClone(int* minranks);
		double* GaussFromNode(Node* node);
		void  InputToResult(int enum_type,int step,double time);
		void   ProcessResultsUnits(void);
		/*}}}*/
		/*Update virtual functions resolution: {{{1*/
		void  InputUpdateFromSolution(double* solutiong);
		void  InputUpdateFromSolutionDiagnosticHoriz( double* solutiong);
		void  InputUpdateFromSolutionDiagnosticStokes( double* solutiong);
		void  InputUpdateFromSolutionSlopeCompute( double* solutiong);
		void  InputUpdateFromSolutionPrognostic( double* solutiong);
		void  InputUpdateFromSolutionPrognostic2(double* solutiong);
		void  InputUpdateFromSolutionBalancedthickness( double* solutiong);
		void  InputUpdateFromSolutionBalancedthickness2( double* solutiong);
		void  InputUpdateFromSolutionBalancedvelocities( double* solutiong);
		void  InputUpdateFromVector(double* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  UpdateFromDakota(void* inputs);
		/*}}}*/
		/*FUNCTION element numerical routines {{{1*/
		void  CreateKMatrix(Mat Kggg);
		void  CreateKMatrixDiagnosticHoriz( Mat Kgg);
		void  CreateKMatrixDiagnosticHutter( Mat Kgg);
		void  CreateKMatrixDiagnosticVert( Mat Kgg);
		void  CreatePVector(Vec pg);
		void  GetSolutionFromInputs(Vec solution);
		void  GetSolutionFromInputsDiagnosticHoriz(Vec solutiong);
		void  GetSolutionFromInputsDiagnosticVert(Vec solutiong);
		void  GetSolutionFromInputsDiagnosticStokes(Vec solutiong);
		void  GetDofList(int* doflist,int* pnumberofdofs);
		void  GetDofList1(int* doflist);
		void* GetMatPar();
		bool   GetShelf();
		void  GetNodes(void** nodes);
		bool   GetOnBed();
		void  Du(Vec du_gg);
		void  Gradj(Vec gradient,int control_type);
		void  GradjDrag(Vec gradient);
		void  GradjB(Vec gradient);
		double Misfit(void);
		double SurfaceArea(void);
		double CostFunction(void);
		void  GetThicknessList(double* thickness_list);
		void  GetBedList(double* bed_list);
		void  GetStrainRate(double* epsilon, double* velocity, double* xyz_list, double* gauss_coord);
		void  GetB(double* pB, double* xyz_list, double* gauss_coord);
		void  GetBPrime(double* B, double* xyz_list, double* gauss_coord);
		void  GetB_vert(double* B, double* xyz_list, double* gauss_coord);
		void  GetBPrime_vert(double* B, double* xyz_list, double* gauss_coord);
		void  GetJacobianDeterminant(double*  Jdet, double* xyz_list,double* gauss_coord);
		void  GetNodalFunctionsDerivatives(double* dh1dh6,double* xyz_list, double* gauss_coord);
		void  GetJacobian(double* J, double* xyz_list,double* gauss_coord);
		void  GetNodalFunctionsDerivativesReference(double* dl1dl6,double* gauss_coord);
		void  GetJacobianInvert(double*  Jinv, double* xyz_list,double* gauss_coord);
		void  CreatePVectorDiagnosticHoriz( Vec pg);
		void  CreatePVectorDiagnosticHutter( Vec pg);
		void  CreatePVectorDiagnosticVert( Vec pg);
		void  GetParameterValue(double* pvalue, double* v_list,double* gauss_coord);
		void  GetParameterDerivativeValue(double* p, double* p_list,double* xyz_list, double* gauss_coord);
		void  GetNodalFunctions(double* l1l6, double* gauss_coord);
		void  VecExtrude(Vec vector,double* vector_serial,int iscollapsed);
		void  InputExtrude(int enum_type);
		void  InputDepthAverageAtBase(int enum_type,int average_enum_type);
		void  ComputeBasalStress(Vec sigma_bg);
		void  ComputePressure(Vec p_gg);
		void  ComputeStrainRate(Vec epsg);
		void  CreateKMatrixSlopeCompute(Mat Kggg);
		void  CreatePVectorSlopeCompute( Vec pg);
		void  CreateKMatrixPrognostic(Mat Kggg);
		void  CreatePVectorPrognostic( Vec pg);
		void  CreateKMatrixBalancedthickness(Mat Kggg);
		void  CreateKMatrixBalancedvelocities(Mat Kggg);
		void  CreateKMatrixDiagnosticStokes( Mat Kgg);
		void  CreatePVectorBalancedthickness( Vec pg);
		void  CreatePVectorBalancedvelocities( Vec pg);
		void  CreatePVectorDiagnosticStokes( Vec pg);
		void  ReduceMatrixStokes(double* Ke_reduced, double* Ke_temp);
		void  GetMatrixInvert(double*  Ke_invert, double* Ke);
		void  SurfaceNormal(double* surface_normal, double xyz_list[3][3]);
		void  GetStrainRateStokes(double* epsilon, double* velocity, double* xyz_list, double* gauss_coord);
		void  GetBStokes(double* B, double* xyz_list, double* gauss_coord);
		void  GetBprimeStokes(double* B_prime, double* xyz_list, double* gauss_coord);
		void  GetLStokes(double* LStokes, double* gauss_coord_tria);
		void  GetLprimeStokes(double* LprimeStokes, double* xyz_list, double* gauss_coord_tria, double* gauss_coord);
		void  GetNodalFunctionsDerivativesStokes(double* dh1dh7,double* xyz_list, double* gauss_coord);
		void  GetNodalFunctionsDerivativesReferenceStokes(double* dl1dl7,double* gauss_coord);
		void  ReduceVectorStokes(double* Pe_reduced, double* Ke_temp, double* Pe_temp);
		void  GetNodalFunctionsStokes(double* l1l7, double* gauss_coord);
		void  CreateKMatrixThermal(Mat Kggg);
		void  GetB_conduct(double* B_conduct, double* xyz_list, double* gauss_coord);
		void  GetB_advec(double* B_advec, double* xyz_list, double* gauss_coord);
		void  GetBprime_advec(double* Bprime_advec, double* xyz_list, double* gauss_coord);
		void  GetB_artdiff(double* B_artdiff, double* xyz_list, double* gauss_coord);
		void  CreateKMatrixMelting(Mat Kggg);
		void  CreatePVectorThermal( Vec pg);
		void  CreatePVectorMelting( Vec pg);
		void  GetPhi(double* phi, double*  epsilon, double viscosity);
		double MassFlux(double* segment);
		void  PatchSize(int* pnumrows, int* pnumvertices,int* pnumnodes);
		void  PatchFill(int* pcount, Patch* patch);
		void  MinVel(double* pminvel, bool process_units);
		void  MaxVel(double* pmaxvel, bool process_units);
		void  MinVx(double* pminvx, bool process_units);
		void  MaxVx(double* pmaxvx, bool process_units);
		void  MaxAbsVx(double* pmaxabsvx, bool process_units);
		void  MinVy(double* pminvy, bool process_units);
		void  MaxVy(double* pmaxvy, bool process_units);
		void  MaxAbsVy(double* pmaxabsvy, bool process_units);
		void  MinVz(double* pminvz, bool process_units);
		void  MaxVz(double* pmaxvz, bool process_units);
		void  MaxAbsVz(double* pmaxabsvz, bool process_units);
		void  InputDuplicate(int original_enum,int new_enum);
		void  InputScale(int enum_type,double scale_factor);
		void  InputAXPY(int YEnum, double scalar, int XEnum);
		void  InputControlConstrain(int control_type,double cm_min, double cm_max);
		void  InputConvergence(int* pconverged,double* eps, int* enums,int num_enums,int* criterionenums,double* criterionvalues,int num_criterionenums);
		void  GetVectorFromInputs(Vec vector,int NameEnum);
		/*}}}*/


};
#endif  /* _PENTA_H */
