/*! \file TriaVertexElementResult.h 
 *  \brief: header file for triavertexresult object
 */


#ifndef _TRIAVERTEXELEMENTRESULT_H_
#define _TRIAVERTEXELEMENTRESULT_H_

/*Headers:*/
/*{{{1*/
#include "../Inputs/Input.h"
#include "../../include/include.h"
/*}}}*/

class TriaVertexElementResult: public ElementResult{

	private: 
		int    enum_type;
		double values[3];
		int    step;
		double time;

	public:

		/*TriaVertexElementResult constructors, destructors: {{{1*/
		TriaVertexElementResult();
		TriaVertexElementResult(int enum_type,double* values,int step,double time);
		~TriaVertexElementResult();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*ElementResult virtual functions definitions: {{{1*/
		ElementResult* SpawnSingElementResult(int  index);
		ElementResult* SpawnBeamElementResult(int* indices);
		ElementResult* SpawnTriaElementResult(int* indices);
		void    ProcessUnits(Parameters* parameters);
		int     NumberOfNodalValues(void);
		void    PatchFill(int row, Patch* patch);
		/*}}}*/
		/*TriaVertexElementResult management: {{{1*/
		int   EnumType();
		/*}}}*/

};
#endif  /* _TRIAVERTEXELEMENTRESULT_H */
