/*! \file DoubleElementResult.h 
 *  \brief: header file for double result object
 *  A double result object is just derived from a DoubleInput object, with additional time and step information.
 */


#ifndef _DOUBLEELEMENTRESULT_H_
#define _DOUBLEELEMENTRESULT_H_

/*Headers:*/
/*{{{1*/
#include "../Inputs/Input.h"
#include "../../include/include.h"
class Parameters;
/*}}}*/

class DoubleElementResult: public ElementResult{

	private: 
		int    enum_type;
		double value;
		int    step;
		double time;

	public:

		/*DoubleElementResult constructors, destructors: {{{1*/
		DoubleElementResult();
		DoubleElementResult(int enum_type,double value,int step,double time);
		~DoubleElementResult();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*ElementResult virtual functions definitions: {{{1*/
		ElementResult* SpawnSingElementResult(int  index);
		ElementResult* SpawnBeamElementResult(int* indices);
		ElementResult* SpawnTriaElementResult(int* indices);
		void    ProcessUnits(Parameters* parameters);
		int     NumberOfNodalValues(void);
		void    PatchFill(int row, Patch* patch);
		/*}}}*/
		/*DoubleElementResult management: {{{1*/
		int   EnumType();
		/*}}}*/
};
#endif  /* _DOUBLEELEMENTRESULT_H */
