/*! \file BeamVertexElementResult.h 
 *  \brief: header file for triavertexresult object
 */


#ifndef _BEAMVERTEXELEMENTRESULT_H_
#define _BEAMVERTEXELEMENTRESULT_H_

/*Headers:*/
/*{{{1*/
#include "../Inputs/Input.h"
#include "../../include/include.h"
/*}}}*/

class BeamVertexElementResult: public ElementResult{

	private: 
		int    enum_type;
		double values[2];
		int    step;
		double time;

	public:

		/*BeamVertexElementResult constructors, destructors: {{{1*/
		BeamVertexElementResult();
		BeamVertexElementResult(int enum_type,double* values,int step,double time);
		~BeamVertexElementResult();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*ElementResult virtual functions definitions: {{{1*/
		ElementResult* SpawnSingElementResult(int  index){ISSMERROR("Not implemented yet!");}
		ElementResult* SpawnBeamElementResult(int* indices){ISSMERROR("Not implemented yet!");}
		ElementResult* SpawnTriaElementResult(int* indices){ISSMERROR("Not implemented yet!");}
		void    ProcessUnits(Parameters* parameters);
		int     NumberOfNodalValues(void);
		void    PatchFill(int row, Patch* patch);
		/*}}}*/
		/*BeamVertexElementResult management: {{{1*/
		int   EnumType();
		/*}}}*/

};
#endif  /* _BEAMVERTEXELEMENTRESULT_H */
