/*!\file Rgb.h
 * \brief: header file for rgb object
 */

#ifndef _RGB_H_
#define _RGB_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"
class DataSet;
/*}}}*/

class Rgb: public Object{

	private: 
		int	id; /*! id, to track it*/
		int	nodeid1; 
		int	nodeid2; 
		int dof; /*!component*/
		int analysis_type;

	public:

		/*Rgb constructors, destructors:{{{1*/
		Rgb();
		Rgb(int rgb_id,int rgb_nodeid1,int rgb_nodeid2, int rgb_dof,int analysis_type);
		~Rgb();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Rgb management: {{{1*/
		int    GetNodeId1();
		int    GetNodeId2();
		int    GetDof();
		bool   InAnalysis(int analysis_type);
		/*}}}*/


};

#endif  /* _RGB_H_ */
