/*!\file Node.h
 * \brief: header file for node object
 */

#ifndef _NODE_H_
#define _NODE_H_

/*Headers:*/
/*{{{1*/
#include "./Object.h"
#include "../shared/shared.h"
class  Inputs;
class  Hook;
class  DofIndexing;
class  IoModel;
class  DataSet;
class  Vertices;
#include "./Update.h"
/*}}}*/

class Node: public Object ,public Update{

	private: 

		int	    id;  //unique arbitrary id.
		int     sid; //sid for "serial" id, ie the rank of this node in the nodes dataset, if the dataset was serial on 1 cpu.
				
		DofIndexing    indexing;
		Hook           hvertex;
		Hook           hupper_node;
		Inputs*        inputs; //properties of this node
		int            analysis_type;
		
	public:

		/*FUNCTION constructors, destructors {{{1*/
		Node();
		Node(int id,int sid, int vertex_id, int upper_node_id, int numberofdofs);
		Node(int id,int sid, DofIndexing* indexing, Hook* vertex, Hook* upper_node, Inputs* inputs,int analysis_type);
		Node(int node_id,int node_sid, int vertex_id,int io_index, IoModel* iomodel,int analysis_type);
		~Node();
		/*}}}*/
		/*Object virtual functions resolution: {{{1*/
		void  Configure(DataSet* nodes,Vertices* vertices);
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id(void); 
		int   Sid(void); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank(void);
		/*}}}*/
		/*Update virtual functions resolution: {{{1*/
		void  InputUpdateFromVector(double* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromSolution(double* solution){ISSMERROR("Not implemented yet!");}
		/*}}}*/
		/*FUNCTION numerical routines {{{1*/
		int   GetVertexDof(void);
		int   GetVertexId(void);
		void  SetVertexDof(int in_dof);
		bool  InAnalysis(int analysis_type);
		int   GetNumberOfDofs();
		int   IsClone();
		void  ApplyConstraint(Vec yg,int dof,double value);
		void  DofInSSet(int dof);
		void  DofInMSet(int dof);
		 int  DofIsInMSet(int dof);
		int   GetDof(int dofindex);
		void  CreateVecSets(Vec pv_g,Vec pv_m,Vec pv_n,Vec pv_f,Vec pv_s);
		int   GetConnectivity();
		void  GetDofList(int* outdoflist,int* pnumberofdofspernode);
		int   GetDofList1(void);
		double GetX();
		double GetY();
		double GetZ();
		double GetSigma();
		Object* copy();
		Node* GetUpperNode();
		int   IsOnBed();
		int   IsOnSurface();
		void  FreezeDof(int dof);
		void  FieldAverageOntoVertices(Vec fieldsum,Vec connectivity,double* field);
		void  FieldDepthAverageAtBase(Vec field,double* field_serial,char* fieldname);
		int   IsOnShelf();
		int   IsOnSheet();
		void  VecExtrude(Vec vector,double* vector_serial);
		/*}}}*/
		/*FUNCTION DofObject routines {{{1*/
		void  DistributeDofs(int* pdofcount);
		void  OffsetDofs(int dofcount);
		void  ShowTrueDofs(int* borderdofs);
		void  UpdateCloneDofs(int* allborderdofs);
		void  SetClone(int* minranks);
		void  CreatePartition(Vec partition);
		/*}}}*/
};

#endif  /* _NODE_H_ */
