/*!\file Matpar.c
 * \brief: implementation of the Matpar object
 */


#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

		
/*Object constructors and destructor*/
/*FUNCTION Matpar::Matpar() {{{1*/
Matpar::Matpar(){
	return;
}
/*}}}1*/
/*FUNCTION Matpar::Matpar(int matpar_mid, double matpar_rho_ice, double matpar_rho_water, double matpar_heatcapacity, ...){{{1*/
Matpar::Matpar(int	matpar_mid, double	matpar_rho_ice, double	matpar_rho_water, double  matpar_heatcapacity, double  matpar_thermalconductivity, double  matpar_latentheat, double  matpar_beta, double  matpar_meltingpoint, double  matpar_mixed_layer_capacity, double  matpar_thermal_exchange_velocity, double  matpar_g){

	this->Init(matpar_mid, matpar_rho_ice, matpar_rho_water, matpar_heatcapacity, matpar_thermalconductivity, matpar_latentheat, matpar_beta, matpar_meltingpoint, matpar_mixed_layer_capacity, matpar_thermal_exchange_velocity, matpar_g);

}
/*}}}1*/
/*FUNCTION Matpar::Matpar(int matpar_mid,IoModel* iomodel){{{1*/
Matpar::Matpar(int matpar_mid, IoModel* iomodel){

	double  matpar_rho_ice;
	double  matpar_rho_water;
	double  matpar_heatcapacity;
	double  matpar_thermalconductivity;
	double  matpar_latentheat;
	double  matpar_beta;
	double  matpar_meltingpoint;
	double  matpar_mixed_layer_capacity;
	double  matpar_thermal_exchange_velocity;
	double  matpar_g;

	matpar_g=iomodel->g; 
	matpar_rho_ice=iomodel->rho_ice; 
	matpar_rho_water=iomodel->rho_water; 
	matpar_thermalconductivity=iomodel->thermalconductivity; 
	matpar_heatcapacity=iomodel->heatcapacity; 
	matpar_latentheat=iomodel->latentheat; 
	matpar_beta=iomodel->beta; 
	matpar_meltingpoint=iomodel->meltingpoint; 
	matpar_mixed_layer_capacity=iomodel->mixed_layer_capacity; 
	matpar_thermal_exchange_velocity=iomodel->thermal_exchange_velocity; 

	this->Init(matpar_mid, matpar_rho_ice, matpar_rho_water, matpar_heatcapacity, matpar_thermalconductivity, matpar_latentheat, matpar_beta, matpar_meltingpoint, matpar_mixed_layer_capacity, matpar_thermal_exchange_velocity, matpar_g);

}
/*}}}1*/
/*FUNCTION Matpar::Init {{{1*/
void Matpar::Init(int	matpar_mid, double	matpar_rho_ice, double	matpar_rho_water, double  matpar_heatcapacity, double  matpar_thermalconductivity, double  matpar_latentheat, double  matpar_beta, double  matpar_meltingpoint, double  matpar_mixed_layer_capacity, double  matpar_thermal_exchange_velocity, double  matpar_g){

	this->mid=matpar_mid; 
	this->rho_ice=matpar_rho_ice; 
	this->rho_water=matpar_rho_water; 
	this->heatcapacity=matpar_heatcapacity; 
	this->thermalconductivity=matpar_thermalconductivity; 
	this->latentheat=matpar_latentheat; 
	this->beta=matpar_beta; 
	this->meltingpoint=matpar_meltingpoint; 
	this->mixed_layer_capacity=matpar_mixed_layer_capacity; 
	this->thermal_exchange_velocity=matpar_thermal_exchange_velocity; 
	this->g=matpar_g; 

	return;
}
/*}}}1*/
/*FUNCTION Matpar::~Matpar() {{{1*/
Matpar::~Matpar(){
	return;
}
/*}}}1*/

/*Object marshall*/
/*FUNCTION Matpar::Demarshall {{{1*/
void  Matpar::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/

	memcpy(&mid,marshalled_dataset,sizeof(mid));marshalled_dataset+=sizeof(mid);
	memcpy(&rho_ice,marshalled_dataset,sizeof(rho_ice));marshalled_dataset+=sizeof(rho_ice);
	memcpy(&rho_water,marshalled_dataset,sizeof(rho_water));marshalled_dataset+=sizeof(rho_water);
	memcpy(&heatcapacity,marshalled_dataset,sizeof(heatcapacity));marshalled_dataset+=sizeof(heatcapacity);
	memcpy(&thermalconductivity,marshalled_dataset,sizeof(thermalconductivity));marshalled_dataset+=sizeof(thermalconductivity);
	memcpy(&latentheat,marshalled_dataset,sizeof(latentheat));marshalled_dataset+=sizeof(latentheat);
	memcpy(&beta,marshalled_dataset,sizeof(beta));marshalled_dataset+=sizeof(beta);
	memcpy(&meltingpoint,marshalled_dataset,sizeof(meltingpoint));marshalled_dataset+=sizeof(meltingpoint);
	memcpy(&mixed_layer_capacity,marshalled_dataset,sizeof(mixed_layer_capacity));marshalled_dataset+=sizeof(mixed_layer_capacity);
	memcpy(&thermal_exchange_velocity,marshalled_dataset,sizeof(thermal_exchange_velocity));marshalled_dataset+=sizeof(thermal_exchange_velocity);
	memcpy(&g,marshalled_dataset,sizeof(g));marshalled_dataset+=sizeof(g);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}1*/
/*FUNCTION Matpar::Marshall {{{1*/
void  Matpar::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of Matpar: */
	enum_type=MatparEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*marshall Matpar data: */
	memcpy(marshalled_dataset,&mid,sizeof(mid));marshalled_dataset+=sizeof(mid);
	memcpy(marshalled_dataset,&rho_ice,sizeof(rho_ice));marshalled_dataset+=sizeof(rho_ice);
	memcpy(marshalled_dataset,&rho_water,sizeof(rho_water));marshalled_dataset+=sizeof(rho_water);
	memcpy(marshalled_dataset,&heatcapacity,sizeof(heatcapacity));marshalled_dataset+=sizeof(heatcapacity);
	memcpy(marshalled_dataset,&thermalconductivity,sizeof(thermalconductivity));marshalled_dataset+=sizeof(thermalconductivity);
	memcpy(marshalled_dataset,&latentheat,sizeof(latentheat));marshalled_dataset+=sizeof(latentheat);
	memcpy(marshalled_dataset,&beta,sizeof(beta));marshalled_dataset+=sizeof(beta);
	memcpy(marshalled_dataset,&meltingpoint,sizeof(meltingpoint));marshalled_dataset+=sizeof(meltingpoint);
	memcpy(marshalled_dataset,&mixed_layer_capacity,sizeof(mixed_layer_capacity));marshalled_dataset+=sizeof(mixed_layer_capacity);
	memcpy(marshalled_dataset,&thermal_exchange_velocity,sizeof(thermal_exchange_velocity));marshalled_dataset+=sizeof(thermal_exchange_velocity);
	memcpy(marshalled_dataset,&g,sizeof(g));marshalled_dataset+=sizeof(g);

	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}1*/
/*FUNCTION Matpar::MarshallSize {{{1*/
int   Matpar::MarshallSize(){

	return sizeof(mid)+
		sizeof(rho_ice)+
		sizeof(rho_water)+
		sizeof(heatcapacity)+
		sizeof(thermalconductivity)+
		sizeof(latentheat)+
		sizeof(beta)+
		sizeof(meltingpoint)+
		sizeof(mixed_layer_capacity)+
		sizeof(thermal_exchange_velocity)+
		sizeof(g)+
		sizeof(int); //sizeof(int) for enum type
}
/*}}}1*/

/*Object functions*/
/*FUNCTION Matpar::copy {{{1*/
Object* Matpar::copy() {
	return new Matpar(*this); 
}
/*}}}1*/
/*FUNCTION Matpar::DeepEcho {{{1*/
void Matpar::DeepEcho(void){

	printf("Matpar:\n");
	printf("   mid: %i\n",mid);
	printf("   rho_ice: %g\n",rho_ice);
	printf("   rho_water: %g\n",rho_water);
	printf("   heatcapacity: %g\n",heatcapacity);
	printf("   thermalconductivity: %g\n",thermalconductivity);
	printf("   latentheat: %g\n",latentheat);
	printf("   beta: %g\n",beta);
	printf("   meltingpoint: %g\n",meltingpoint);
	printf("   mixed_layer_capacity: %g\n",mixed_layer_capacity);
	printf("   thermal_exchange_velocity: %g\n",thermal_exchange_velocity);
	printf("   g: %g\n",g);
	return;
}		
/*}}}1*/
/*FUNCTION Matpar::Echo {{{1*/
void Matpar::Echo(void){

	printf("Matpar:\n");
	printf("   mid: %i\n",mid);
	printf("   rho_ice: %g\n",rho_ice);
	printf("   rho_water: %g\n",rho_water);
	printf("   heatcapacity: %g\n",heatcapacity);
	printf("   thermalconductivity: %g\n",thermalconductivity);
	printf("   latentheat: %g\n",latentheat);
	printf("   beta: %g\n",beta);
	printf("   meltingpoint: %g\n",meltingpoint);
	printf("   mixed_layer_capacity: %g\n",mixed_layer_capacity);
	printf("   thermal_exchange_velocity: %g\n",thermal_exchange_velocity);
	printf("   g: %g\n",g);
	return;
}
/*}}}1*/
/*FUNCTION Matpar::Enum {{{1*/
int Matpar::Enum(void){

	return MatparEnum;

}
/*}}}1*/
/*FUNCTION Matpar::GetBeta {{{1*/
double Matpar::GetBeta(){
	return beta;
}
/*}}}1*/
/*FUNCTION Matpar::GetG {{{1*/
double Matpar::GetG(){
	return g;
}
/*}}}1*/
/*FUNCTION Matpar::GetHeatCapacity {{{1*/
double Matpar::GetHeatCapacity(){
	return heatcapacity;
}
/*}}}1*/
/*FUNCTION Matpar::Id {{{1*/
int    Matpar::Id(void){ return mid; }
/*}}}1*/
/*FUNCTION Matpar::GetLatentHeat {{{1*/
double Matpar::GetLatentHeat(){
	return latentheat;
}
/*}}}1*/
/*FUNCTION Matpar::GetMeltingPoint {{{1*/
double Matpar::GetMeltingPoint(){
	return meltingpoint;
}
/*}}}1*/
/*FUNCTION Matpar::GetMixedLayerCapacity {{{1*/
double Matpar::GetMixedLayerCapacity(){
	return mixed_layer_capacity;
}
/*}}}1*/
/*FUNCTION Matpar::GetRhoIce {{{1*/
double Matpar::GetRhoIce(){
	
	return rho_ice;
}
/*}}}1*/
/*FUNCTION Matpar::GetRhoWater {{{1*/
double Matpar::GetRhoWater(){
	return rho_water;
}
/*}}}1*/
/*FUNCTION Matpar::GetThermalConductivity {{{1*/
double Matpar::GetThermalConductivity(){
	return thermalconductivity;
}
/*}}}1*/
/*FUNCTION Matpar::GetThermalExchangeVelocity {{{1*/
double Matpar::GetThermalExchangeVelocity(){
	return thermal_exchange_velocity;
}
/*}}}1*/
/*FUNCTION Matpar::MyRank {{{1*/
int    Matpar::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}1*/
/*FUNCTION Matpar::InputUpdateFromVector(double* vector, int name, int type) {{{1*/
void   Matpar::InputUpdateFromVector(double* vector, int name, int type){
	/*Nothing updated yet*/
}
/*}}}*/
/*FUNCTION Matpar::InputUpdateFromVector(int* vector, int name, int type) {{{1*/
void   Matpar::InputUpdateFromVector(int* vector, int name, int type){
	/*Nothing updated yet*/
}
/*}}}*/
/*FUNCTION Matpar::InputUpdateFromVector(bool* vector, int name, int type) {{{1*/
void   Matpar::InputUpdateFromVector(bool* vector, int name, int type){
	/*Nothing updated yet*/
}
/*}}}*/
/*FUNCTION Matpar::InputUpdateFromConstant(double constant, int name) {{{1*/
void   Matpar::InputUpdateFromConstant(double constant, int name){
	/*Nothing updated yet*/
}
/*}}}*/
/*FUNCTION Matpar::InputUpdateFromConstant(int constant, int name) {{{1*/
void   Matpar::InputUpdateFromConstant(int constant, int name){
	/*Nothing updated yet*/
}
/*}}}*/
/*FUNCTION Matpar::InputUpdateFromConstant(bool constant, int name) {{{1*/
void   Matpar::InputUpdateFromConstant(bool constant, int name){
	/*Nothing updated yet*/
}
/*}}}*/
/*FUNCTION Matpar::InputUpdateFromSolution(double* solution) {{{1*/
void   Matpar::InputUpdateFromSolution(double* solution){
	/*Nothing updated yet*/
}
/*}}}*/
