/*!\file Matice.h
 * \brief: header file for matice object
 */

#ifndef MATICE_H_
#define MATICE_H_

/*Headers:*/
/*{{{1*/
#include "./Material.h"
class IoModel;
/*}}}*/

class Matice: public Material{

	private: 
		int	   mid;
		double B;
		double n;

	public:

		Matice();
		Matice(int mid,double B,double n);
		Matice(int mid,int i, IoModel* iomodel);
		void Init(int mid,double B,double n);
		~Matice();

		/*Object virtual functions resolution: {{{1*/
		void  Echo();
		Object* copy();
		void  DeepEcho();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   Id(); 
		int   MyRank();
		/*}}}*/
		/*Update virtual functions resolution: {{{1*/
		void  InputUpdateFromVector(double* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromSolution(double* solution);
		/*}}}*/
		/*Numerics: {{{1*/
		void   SetB(double B_param);
		void   GetViscosity2d(double* pviscosity, double* pepsilon);
		void   GetViscosity3d(double* pviscosity3d, double* pepsilon);
		void   GetViscosity3dStokes(double* pviscosity3d, double* epsilon);
		void   GetViscosityComplement(double* pviscosity_complement, double* pepsilon);
		double GetB();
		double GetN();
		/*}}}*/
};

#endif  /* _MATICE_H_ */
