/*! \file StringExternalResult.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _STRINGEXTERNALRESULT_H_
#define _STRINGEXTERNALRESULT_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif


#include "./ExternalResult.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class StringExternalResult: public ExternalResult{

	private: 
		int    id;
		int    enum_type;
		char*  value;
		int    step;
		double time;

	public:
		/*constructors, destructors: {{{1*/
		StringExternalResult();
		StringExternalResult(int id,int enum_type,char* value,int step, double time);
		~StringExternalResult();
		/*}}}*/
		/*Object methods: {{{1*/
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		/*}}}*/
		/*ExternalResult methods: {{{1*/
		int   EnumType(){return enum_type;}
		void  WriteData(FILE* fid);
		char* GetResultName(void);
		#ifdef _SERIAL_
		void  SetMatlabField(mxArray* dataref);
		#endif
		int   GetStep(void);
		/*}}}*/
};
#endif  /* _STRINGEXTERNALRESULT_H */
