/*! \file SingVertexElementResult.h 
 *  \brief: header file for triavertexresult object
 */


#ifndef _SINGVERTEXELEMENTRESULT_H_
#define _SINGVERTEXELEMENTRESULT_H_

/*Headers:*/
/*{{{1*/
#include "../Inputs/Input.h"
#include "../../include/include.h"
/*}}}*/

class SingVertexElementResult: public ElementResult{

	private: 
		int    enum_type;
		double value;
		int    step;
		double time;

	public:

		/*constructors, destructors: {{{1*/
		SingVertexElementResult();
		SingVertexElementResult(int enum_type,double value,int step,double time);
		~SingVertexElementResult();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();
		/*}}}*/
		/*result virtual functions: {{{1*/
		ElementResult* SpawnSingElementResult(int  index){ISSMERROR("Not implemented yet!");}
		ElementResult* SpawnBeamElementResult(int* indices){ISSMERROR("Not implemented yet!");}
		ElementResult* SpawnTriaElementResult(int* indices){ISSMERROR("Not implemented yet!");}
		void    ProcessUnits(Parameters* parameters);
		int     NumberOfNodalValues(void);
		void    PatchFill(int row, Patch* patch);
		/*}}}*/

};
#endif  /* _SINGVERTEXELEMENTRESULT_H */
