/*! \file DoubleElementResult.h 
 *  \brief: header file for double result object
 *  A double result object is just derived from a DoubleInput object, with additional time and step information.
 */


#ifndef _DOUBLEELEMENTRESULT_H_
#define _DOUBLEELEMENTRESULT_H_

/*Headers:*/
/*{{{1*/
#include "../Inputs/Input.h"
#include "../../include/include.h"
class Parameters;
/*}}}*/

class DoubleElementResult: public ElementResult{

	private: 
		int    enum_type;
		double value;
		int    step;
		double time;

	public:

		/*constructors, destructors: {{{1*/
		DoubleElementResult();
		DoubleElementResult(int enum_type,double value,int step,double time);
		~DoubleElementResult();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();
		/*}}}*/
		/*result virtual functions: {{{1*/
		ElementResult* SpawnSingElementResult(int  index);
		ElementResult* SpawnBeamElementResult(int* indices);
		ElementResult* SpawnTriaElementResult(int* indices);
		void    ProcessUnits(Parameters* parameters);
		int     NumberOfNodalValues(void);
		void    PatchFill(int row, Patch* patch);
		/*}}}*/

};
#endif  /* _DOUBLEELEMENTRESULT_H */
