/*!\file Spc.h
 * \brief: header file for spc object
 */

#ifndef _SPC_H_
#define _SPC_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"
class DataSet;
/*}}}*/

class Spc: public Object{

	private: 
		int	sid; /*! id, to track it*/
		int	nodeid; /*!node id*/
		int dof; /*!component*/
		double value; /*value*/
		int analysis_type;

	public:

		Spc();
		Spc(int sid,int nodeid, int dof,double value,int analysis_type);
		~Spc();

		void   Echo();
		void   DeepEcho();
		void   Marshall(char** pmarshalled_dataset);
		int    MarshallSize();
		void   Demarshall(char** pmarshalled_dataset);
		int    Enum();
		int    Id(); 
		int    MyRank();
		int    GetNodeId();
		int    GetDof();
		double GetValue();
		Object* copy();
		bool    InAnalysis(int analysis_type);



};

#endif  /* _SPC_H_ */
