function structure=ProcessPatch(structure,step,Patch);
%PROCESSPATCH - create a structure from a patch
%
%   Usage:
%      Result=ProcessPatch(Patch);

%Get number of fields;
fields=unique(Patch(:,1));

%parse fields
for i=1:length(fields),

	%get name
	fieldname=EnumAsString(fields(i));

	%get line positions
	pos=find(Patch(:,1)==fields(i));

	%Fill Result structure
	%structure(step).(fieldname).steps=Patch(pos,2);
	%structure(step).(fieldname).time=Patch(pos,3);
	structure(step).(fieldname).element=Patch(pos,4);
	structure(step).(fieldname).interpolation=Patch(pos,5);
	structure(step).(fieldname).index=Patch(pos,6:8);
	structure(step).(fieldname).value=Patch(pos,9:end);

end

