/*! \file DoubleInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _DOUBLEINPUT_H_
#define _DOUBLEINPUT_H_

/*Headers:*/
/*{{{1*/
#include "./Input.h"
#include "../../include/include.h"
/*}}}*/

class DoubleInput: public Input{

	public:
		int    enum_type;
		double value;

		/*constructors, destructors: {{{1*/
		DoubleInput();
		DoubleInput(int enum_type,IssmDouble value);
		~DoubleInput();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();

		void    InputUpdateFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromSolution(double* solution){ISSMERROR("Not implemented yet!");}

		Input* SpawnSingInput(int  index);
		Input* SpawnBeamInput(int* indices);
		Input* SpawnTriaInput(int* indices);
		ElementResult* SpawnResult(int step, double time);

		/*}}}*/
		/*numerics: {{{1*/
		void GetParameterValue(bool* pvalue);
		void GetParameterValue(int* pvalue);
		void GetParameterValue(double* pvalue);
		void GetParameterValue(double* pvalue,Node* node);
		void GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord);
		void GetParameterValue(double* pvalue,double* gauss);
		void GetParameterValue(double* pvalue,double* gauss,double defaultvalue);
		
		void GetParameterAverage(double* pvalue){ISSMERROR("not implemented yet");};
		
		void GetParameterValues(double* values,double* gauss_pointers, int numgauss);
	
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss);
		void GetVxStrainRate2d(double* epsilonvx,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate2d(double* epsilonvy,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVxStrainRate3d(double* epsilonvx,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate3d(double* epsilonvy,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVzStrainRate3d(double* epsilonvz,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVxStrainRate3dPattyn(double* epsilonvx,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate3dPattyn(double* epsilonvy,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void ChangeEnum(int newenumtype);
		void SquareMin(double* psquaremin, bool process_units,Parameters* parameters);
		void Scale(double scale_factor);
		void AXPY(Input* xinput,double scalar);
		void Constrain(double cm_min, double cm_max);
		void GetVectorFromInputs(Vec vector,int* doflist);
		void GetValuesPtr(double** pvalues,int* pnum_values);
		/*}}}*/

};
#endif  /* _DOUBLEINPUT_H */
