/*!\file SingVertexElementResult.c
 * \brief: implementation of the SingVertexElementResult object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "./ElementResultLocal.h"
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

/*Object constructors and destructor*/
/*FUNCTION SingVertexElementResult::SingVertexElementResult(){{{1*/
SingVertexElementResult::SingVertexElementResult(){
	return;
}
/*}}}*/
/*FUNCTION SingVertexElementResult::SingVertexElementResult(int in_enum_type,double* in_values,int in_step, double in_time){{{1*/
SingVertexElementResult::SingVertexElementResult(int in_enum_type,double in_value,int in_step, double in_time){

	enum_type=in_enum_type;
	value=in_value;
	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION SingVertexElementResult::~SingVertexElementResult(){{{1*/
SingVertexElementResult::~SingVertexElementResult(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION SingVertexElementResult::copy{{{1*/
Object* SingVertexElementResult::copy() {
	
	return new SingVertexElementResult(this->enum_type,this->value,this->step,this->time);

}
/*}}}*/
/*FUNCTION SingVertexElementResult::DeepEcho{{{1*/
void SingVertexElementResult::DeepEcho(void){
		
	printf("SingVertexElementResult:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumAsString(this->enum_type));
	printf("   value: %g\n",this->value);
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);

}
/*}}}*/
/*FUNCTION SingVertexElementResult::Demarshall{{{1*/
void  SingVertexElementResult::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);
	memcpy(&time,marshalled_dataset,sizeof(time));marshalled_dataset+=sizeof(time);
	memcpy(&step,marshalled_dataset,sizeof(step));marshalled_dataset+=sizeof(step);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION SingVertexElementResult::Echo {{{1*/
void SingVertexElementResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION SingVertexElementResult::Enum{{{1*/
int SingVertexElementResult::Enum(void){

	return SingVertexElementResultEnum;

}
/*}}}*/
/*FUNCTION SingVertexElementResult::EnumType{{{1*/
int SingVertexElementResult::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION SingVertexElementResult::Id{{{1*/
int    SingVertexElementResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION SingVertexElementResult::Marshall{{{1*/
void  SingVertexElementResult::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of SingVertexElementResult: */
	enum_value=SingVertexElementResultEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall SingVertexElementResult data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);
	memcpy(marshalled_dataset,&time,sizeof(time));marshalled_dataset+=sizeof(time);
	memcpy(marshalled_dataset,&step,sizeof(step));marshalled_dataset+=sizeof(step);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION SingVertexElementResult::MarshallSize{{{1*/
int   SingVertexElementResult::MarshallSize(){
	
	return sizeof(value)+
		+sizeof(enum_type)
		+sizeof(time)
		+sizeof(step)
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION SingVertexElementResult::MyRank{{{1*/
int    SingVertexElementResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/

/*ElementResult functions*/
/*FUNCTION SingVertexElementResult::ProcessUnits(Parameters* parameters){{{1*/
void SingVertexElementResult::ProcessUnits(Parameters* parameters){
	
	NodalValuesUnitConversion(&this->value,1,this->enum_type,parameters);

}
/*}}}*/
/*FUNCTION SingVertexElementResult::NumberOfNodalValues(void){{{1*/
int SingVertexElementResult::NumberOfNodalValues(void){
	return 1;
}
/*}}}*/
/*FUNCTION SingVertexElementResult::SingVertexElementResult::PatchFill(int row, Patch* patch){{{1*/
void SingVertexElementResult::PatchFill(int row, Patch* patch){
	
	 /*Here, we fill the result information into the patch object. First, let's remember what is in a row 
	  * of the patch object: enum_type step time element_id interpolation vertices_ids nodal_values
	  * Here, we will supply the enum_type, step, time, interpolation and nodal_values: */
	patch->fillresultinfo(row,this->enum_type,this->step,this->time,P0Enum,&this->value,1);

}
/*}}}*/
