/*
 * CreateConstraintsDiagnosticHutter.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsDiagnosticHutter(Constraints** pconstraints, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int i;
	int count;

	/*Output*/
	Constraints* constraints = NULL;
	Spc*    spc  = NULL;

	/*Recover pointer: */
	constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints(ConstraintsEnum);

	/*Now, is the flag ishutter on? otherwise, do nothing: */
	if (!iomodel->ishutter) goto cleanup_and_return;

	/*Fetch data: */
	IoModelFetchData(&iomodel->gridonhutter,NULL,NULL,iomodel_handle,"gridonhutter");

	/*Initialize conunter*/
	count=0;

	/*vx and vy are spc'd if we are not on gridonhutter: */
	for (i=0;i<iomodel->numberofvertices;i++){
		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i])){
			if (!(int)iomodel->gridonhutter[i]){

				constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,0,DiagnosticHutterAnalysisEnum));
				count++;

				constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,2,0,DiagnosticHutterAnalysisEnum));
				count++;
			}
		} //if((my_vertices[i]))
	}

	/*Free data: */
	xfree((void**)&iomodel->gridonhutter);

	cleanup_and_return:
	
	/*Assign output pointer: */
	*pconstraints=constraints;
}
