/*!\file: Inputs.h
 * \brief prototypes for Inputs.h
 */ 

#ifndef _CONTAINER_INPUTS_H_
#define  _CONTAINER_INPUTS_H_

/*forward declarations */
class Materials;
class Parameters;
class Elements;
class Vertices;
class Loads;
class Nodes;
class DataSet;
class Input;
class Node;

class Inputs: public DataSet{

	public:

		/*constructors, destructors: {{{1*/
		Inputs();
		Inputs(int enum_type);
		~Inputs();

		/*}}}*/
		/*numerics: {{{1*/
		int     AddInput(Input* in_input);
		Input* GetInput(int enum_name);
		Inputs* SpawnTriaInputs(int* indices);
		Inputs* SpawnBeamInputs(int* indices);
		Inputs* SpawnSingInputs(int  index  );
		
		void GetParameterValue(bool* pvalue,int enum_type);
		void GetParameterValue(int* pvalue,int enum_type);
		void GetParameterValue(double* pvalue,int enum_type);
		void GetParameterValue(double* pvalue,Node* node,int enum_type);
		void GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord,int enum_type);
		void GetParameterValue(double* pvalue,double* gauss,int enum_type);
		void GetParameterValue(double* pvalue,double* gauss,int enum_type,double defaultvalue);
		void GetParameterAverage(double* pvalue, int enum_type);
		
		void GetParameterValues(double* values,double* gauss_pointers, int numgauss,int enum_type);
		void GetParameterValues(double* values,double* gauss_pointers, int numgauss,int enum_type,double* defaultvalues);
	
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss,int enum_type);
		void GetStrainRate2d(double* epsilon,double* xyz_list, double* gauss, int vxenum, int vyenum);
		void GetStrainRate3d(double* epsilon,double* xyz_list, double* gauss, int vxenum, int vyenum,int vzenum);
		void GetStrainRate3dPattyn(double* epsilon,double* xyz_list, double* gauss, int vxenum, int vyenum);

		void ChangeEnum(int enumtype,int new_enumtype);

		/*}}}*/

};



#endif //ifndef _INPUTS_H_
