/*!\file: Constraints.h
 * \brief prototypes for Constraints.h
 */ 

#ifndef _CONTAINER_CONSTRAINTS_H_
#define  _CONTAINER_CONSTRAINTS_H_

/*forward declarations */
class Materials;
class Parameters;
class Elements;
class Vertices;
class Loads;
class Nodes;
class DataSet;
class Inputs;


class Constraints: public DataSet{

	public:

		/*constructors, destructors: {{{1*/
		Constraints();
		Constraints(int enum_type);
		~Constraints();
		/*}}}*/
		/*numerics: {{{1*/
		int   NumberOfLocalRgbs(int analysis_type);
		int   NumberOfConstraints(void);
		void  SetupSpcs(Nodes* nodes,Vec yg,int analysis_type);
		void  SetupMpcs(Mat Rmg,Nodes* nodes,int analysis_type);
		/*}}}*/

};


#endif //ifndef _CONSTRAINTS_H_

