/*!\file: controlconvergence.cpp
 * \brief: determine convergence of control_core solution
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../Container/Container.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../include/include.h"
#include "../modules/modules.h"
#include "./solutions.h"


int controlconvergence(double* J, double* fit, double eps_cm, int n){

	int i;
	int converged=0;

	/*Has convergence been reached?*/
	if (!isnan(eps_cm)){
		i=n-2;

		//go through the previous misfits(starting from n-2)
		while(i>=0){
			if (fit[i]==fit[n]){
				//convergence test only if we have the same misfits
				if ((J[i]-J[n])/J[n] <= eps_cm){
					//convergence if convergence criteria fullfilled
					converged=1;
					_printf_("%s%g%s%g\n","      Convergence criterion: dJ/J = ",(J[i]-J[n])/J[n],"<",eps_cm);
				}
				else{
					_printf_("%s%g%s%g\n","      Convergence criterion: dJ/J = ",(J[i]-J[n])/J[n],">",eps_cm);
				}
				break;
			}
			i=i-1;
		}
	}


	return converged;
}

