/*!\file UpdateGeometryx
 * \brief: update geometry node by node
 */

#include "./UpdateGeometryx.h"
#include "../modules.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../Container/Container.h"

void UpdateGeometryx( Elements* elements, Nodes* nodes, Vertices* vertices,Loads* loads, Materials* materials, Parameters* parameters){

	/*Intermediary*/
	int i;
	Element* element=NULL;

	/*First, get elements and loads configured: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Elements drive the update: */
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->UpdateGeometry();
	}
	
}
