/*
 * CreateNodesPrognostic2.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../io/io.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesPrognostic2(Nodes** pnodes, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int i,j;
	bool continuous_galerkin=false;
	int  node_id;
	int  vertex_id;
	int  io_index;

	/*DataSets: */
	Nodes* nodes = NULL;

	/*Recover pointer: */
	nodes=*pnodes;

	/*Create nodes if they do not exist yet*/
	if(!nodes) nodes = new Nodes(NodesEnum);

	/*Continuous Galerkin partition of nodes: */
	NodesPartitioning(&iomodel->my_nodes,iomodel->my_elements, iomodel->my_vertices, iomodel->my_bordervertices, iomodel, iomodel_handle,continuous_galerkin);

	/*Create nodes: */
	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");
	IoModelFetchData(&iomodel->gridonsurface,NULL,NULL,iomodel_handle,"gridonsurface");
	IoModelFetchData(&iomodel->gridonhutter,NULL,NULL,iomodel_handle,"gridonhutter");
	IoModelFetchData(&iomodel->gridonicesheet,NULL,NULL,iomodel_handle,"gridonicesheet");
	IoModelFetchData(&iomodel->gridoniceshelf,NULL,NULL,iomodel_handle,"gridoniceshelf");
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
	if (iomodel->dim==3){
		IoModelFetchData(&iomodel->deadgrids,NULL,NULL,iomodel_handle,"deadgrids");
		IoModelFetchData(&iomodel->uppernodes,NULL,NULL,iomodel_handle,"uppergrids");
	}

	/*Build Nodes dataset -> 3 for each element (Discontinuous Galerkin)*/
	for (i=0;i<iomodel->numberofelements;i++){
		for (j=0;j<3;j++){

			if(iomodel->my_nodes[3*i+j]){ 

				//Get index of the vertex on which the current node is located
				vertex_id=(int)*(iomodel->elements+3*i+j); //(Matlab indexing)
				io_index=vertex_id-1;                      //(C indexing)
				ISSMASSERT(vertex_id>0 && vertex_id<=iomodel->numberofvertices);

				//Compute Node id
				node_id=iomodel->nodecounter+3*i+j+1;

				/*Add node to nodes dataset: */
				nodes->AddObject(new Node(node_id,node_id-1,vertex_id,io_index,iomodel,Balancedthickness2AnalysisEnum));

			}
		}
	}

	/*Clean fetched data: */
	xfree((void**)&iomodel->deadgrids);
	xfree((void**)&iomodel->gridonbed);
	xfree((void**)&iomodel->gridonsurface);
	xfree((void**)&iomodel->gridonhutter);
	xfree((void**)&iomodel->uppernodes);
	xfree((void**)&iomodel->gridonicesheet);
	xfree((void**)&iomodel->gridoniceshelf);

	/*Assign output pointer: */
	*pnodes=nodes;
}
