/*
 * CreateConstraintsBalancedvelocities.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsBalancedvelocities(Constraints** pconstraints, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int i;
	int count=0;
	
	/*Output*/
	Constraints* constraints = NULL;
	Spc*    spc  = NULL;

	/*Recover pointer: */
	constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints(ConstraintsEnum);

	/*Fetch data: */
	IoModelFetchData(&iomodel->spcvelocity,NULL,NULL,iomodel_handle,"spcvelocity");

	count=1; //matlab indexing
	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<iomodel->numberofvertices;i++){
		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i]==1)){

			if ((int)iomodel->spcvelocity[6*i+0] && (int)iomodel->spcvelocity[6*i+1]){ //spc if vx and vy are constrained

				/*This grid needs to be spc'd: */
				constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,
								pow( pow(*(iomodel->spcvelocity+6*i+4),2.0) + pow(*(iomodel->spcvelocity+6*i+5),2.0) ,0.5),BalancedvelocitiesAnalysisEnum));
				count++;
			}
		} //if((my_vertices[i]==1))
	}

	/*Free data: */
	xfree((void**)&iomodel->spcvelocity);
	
	/*Assign output pointer: */
	*pconstraints=constraints;
}
