/*!\file: Parameters.h
 * \brief prototypes for Parameters.h
 */ 

#ifndef _CONTAINER_PARAMETERS_H_
#define  _CONTAINER_PARAMETERS_H_

/*forward declarations */
class Materials;
class Parameters;
class Elements;
class Vertices;
class Loads;
class Nodes;
class DataSet;
class Inputs;

class Parameters: public DataSet{

	public:

		/*constructors, destructors: {{{1*/
		Parameters();
		Parameters(int enum_type);
		~Parameters();
		/*}}}*/
		/*numerics: {{{1*/
		int   FindParam(bool* pinteger,int enum_type);
		int   FindParam(int* pinteger,int enum_type);
		int   FindParam(double* pscalar, int enum_type);
		int   FindParam(char** pstring,int enum_type);
		int   FindParam(char*** pstringarray,int* pM,int enum_type);
		int   FindParam(double** pdoublearray,int* pM,int enum_type);
		int   FindParam(double** pdoublearray,int* pM,int* pN,int enum_type);
		int   FindParam(Vec* pvec,int enum_type);
		int   FindParam(Mat* pmat,int enum_type);
		
		void  SetParam(bool boolean,int enum_type);
		void  SetParam(int integer,int enum_type);
		void  SetParam(double scalar, int enum_type);
		void  SetParam(char* string,int enum_type);
		void  SetParam(char** stringarray,int M,int enum_type);
		void  SetParam(double* doublearray,int M,int enum_type);
		void  SetParam(double* doublearray,int M,int N,int enum_type);
		void  SetParam(Vec vec,int enum_type);
		void  SetParam(Mat mat,int enum_type);

		Object* FindParamObject(int enum_type);
		/*}}}*/

};



#endif //ifndef _PARAMETERS_H_

