/*
 * \file Parameters.c
 * \brief: implementation of the Parameters class, derived from DataSet class
 */

/*Headers: {{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <vector>
#include <functional>
#include <algorithm>
#include <iostream>

#include "./DataSet.h"
#include "../shared/shared.h"
#include "../include/include.h"
#include "../EnumDefinitions/EnumDefinitions.h"

using namespace std;
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION Parameters::Parameters(){{{1*/
Parameters::Parameters(){
	return;
}
/*}}}*/
/*FUNCTION Parameters::Parameters(int in_enum){{{1*/
Parameters::Parameters(int in_enum): DataSet(in_enum){
	//do nothing;
	return;
}
/*}}}*/
/*FUNCTION Parameters::~Parameters(){{{1*/
Parameters::~Parameters(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION Parameters::FindParam(bool* pbool,int enum_type){{{1*/
int   Parameters::FindParam(bool* pbool,int enum_type){
	
	/*Go through a dataset, and find a Param* object 
	 *which parameter name is "name" : */
	
	vector<Object*>::iterator object;
	Param* param=NULL;

	int found=0;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Ok, this object is a parameter, recover it and ask which name it has: */
		param=(Param*)(*object);

		if(param->EnumType()==enum_type){
			/*Ok, this is the one! Recover the value of this parameter: */
			param->GetParameterValue(pbool);
			found=1;
			break;
		}
	}
	return found;
}
/*}}}*/
/*FUNCTION Parameters::FindParam(int* pinteger,int enum_type){{{1*/
int   Parameters::FindParam(int* pinteger,int enum_type){
	
	/*Go through a dataset, and find a Param* object 
	 *which parameter name is "name" : */
	
	vector<Object*>::iterator object;
	Param* param=NULL;

	int found=0;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Ok, this object is a parameter, recover it and ask which name it has: */
		param=(Param*)(*object);

		if(param->EnumType()==enum_type){
			/*Ok, this is the one! Recover the value of this parameter: */
			param->GetParameterValue(pinteger);
			found=1;
			break;
		}
	}
	return found;
}
/*}}}*/
/*FUNCTION Parameters::FindParam(double* pscalar, int enum_type){{{1*/
int   Parameters::FindParam(double* pscalar, int enum_type){
	
	/*Go through a dataset, and find a Param* object 
	 *which parameter name is "name" : */
	
	vector<Object*>::iterator object;
	Param* param=NULL;

	int found=0;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Ok, this object is a parameter, recover it and ask which name it has: */
		param=(Param*)(*object);

		if(param->EnumType()==enum_type){
			/*Ok, this is the one! Recover the value of this parameter: */
			param->GetParameterValue(pscalar);
			found=1;
			break;
		}
	}
	return found;
}
/*}}}*/
/*FUNCTION Parameters::FindParam(char** pstring,int enum_type){{{1*/
int   Parameters::FindParam(char** pstring,int enum_type){
	
	/*Go through a dataset, and find a Param* object 
	 *which parameter name is "name" : */
	
	vector<Object*>::iterator object;
	Param* param=NULL;

	int found=0;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Ok, this object is a parameter, recover it and ask which name it has: */
		param=(Param*)(*object);

		if(param->EnumType()==enum_type){
			/*Ok, this is the one! Recover the value of this parameter: */
			param->GetParameterValue(pstring);
			found=1;
			break;
		}
	}
	return found;

}
/*}}}*/
/*FUNCTION Parameters::FindParam(char*** pstringarray,int* pM,int enum_type){{{1*/
int   Parameters::FindParam(char*** pstringarray,int* pM,int enum_type){
	
	/*Go through a dataset, and find a Param* object 
	 *which parameter name is "name" : */
	
	vector<Object*>::iterator object;
	Param* param=NULL;

	int found=0;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Ok, this object is a parameter, recover it and ask which name it has: */
		param=(Param*)(*object);

		if(param->EnumType()==enum_type){
			/*Ok, this is the one! Recover the value of this parameter: */
			param->GetParameterValue(pstringarray,pM);
			found=1;
			break;
		}
	}
	return found;

}
/*}}}*/
/*FUNCTION Parameters::FindParam(double** pdoublearray,int* pM,int enum_type){{{1*/
int   Parameters::FindParam(double** pdoublearray,int* pM, int enum_type){
	
	/*Go through a dataset, and find a Param* object 
	 *which parameter name is "name" : */
	
	vector<Object*>::iterator object;
	Param* param=NULL;

	int found=0;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Ok, this object is a parameter, recover it and ask which name it has: */
		param=(Param*)(*object);

		if(param->EnumType()==enum_type){
			/*Ok, this is the one! Recover the value of this parameter: */
			param->GetParameterValue(pdoublearray,pM);
			found=1;
			break;
		}
	}
	return found;

}
/*}}}*/
/*FUNCTION Parameters::FindParam(double** pdoublearray,int* pM, int* pN,int enum_type){{{1*/
int   Parameters::FindParam(double** pdoublearray,int* pM, int* pN,int enum_type){
	
	/*Go through a dataset, and find a Param* object 
	 *which parameter name is "name" : */
	
	vector<Object*>::iterator object;
	Param* param=NULL;

	int found=0;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Ok, this object is a parameter, recover it and ask which name it has: */
		param=(Param*)(*object);

		if(param->EnumType()==enum_type){
			/*Ok, this is the one! Recover the value of this parameter: */
			param->GetParameterValue(pdoublearray,pM,pN);
			found=1;
			break;
		}
	}
	return found;

}
/*}}}*/
/*FUNCTION Parameters::FindParam(Vec* pvec,int enum_type){{{1*/
int   Parameters::FindParam(Vec* pvec,int enum_type){
	
	/*Go through a dataset, and find a Param* object 
	 *which parameter name is "name" : */
	
	vector<Object*>::iterator object;
	Param* param=NULL;

	int found=0;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Ok, this object is a parameter, recover it and ask which name it has: */
		param=(Param*)(*object);

		if(param->EnumType()==enum_type){
			/*Ok, this is the one! Recover the value of this parameter: */
			param->GetParameterValue(pvec);
			found=1;
			break;
		}
	}
	return found;

}
/*}}}*/
/*FUNCTION Parameters::FindParam(Mat* pmat,int enum_type){{{1*/
int   Parameters::FindParam(Mat* pmat,int enum_type){
	
	/*Go through a dataset, and find a Param* object 
	 *which parameter name is "name" : */
	
	vector<Object*>::iterator object;
	Param* param=NULL;

	int found=0;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Ok, this object is a parameter, recover it and ask which name it has: */
		param=(Param*)(*object);

		if(param->EnumType()==enum_type){
			/*Ok, this is the one! Recover the value of this parameter: */
			param->GetParameterValue(pmat);
			found=1;
			break;
		}
	}
	return found;

}
/*}}}*/

/*FUNCTION Parameters::SetParam(bool boolean,int enum_type);{{{1*/
void   Parameters::SetParam(bool boolean,int enum_type){

	Param* param=NULL;
	
	/*first, figure out if the param has already been created: */
	param=(Param*)this->FindParamObject(enum_type);

	if(param) param->SetValue(boolean); //already exists, just set it.
	else this->AddObject(new BoolParam(enum_type,boolean)); //just add the new parameter.
}
/*}}}*/
/*FUNCTION Parameters::SetParam(int integer,int enum_type);{{{1*/
void   Parameters::SetParam(int integer,int enum_type){

	Param* param=NULL;
	
	/*first, figure out if the param has already been created: */
	param=(Param*)this->FindParamObject(enum_type);

	if(param) param->SetValue(integer); //already exists, just set it.
	else this->AddObject(new IntParam(enum_type,integer)); //just add the new parameter.
}
/*}}}*/
/*FUNCTION Parameters::SetParam(double scalar,int enum_type);{{{1*/
void   Parameters::SetParam(double scalar,int enum_type){

	Param* param=NULL;
	
	/*first, figure out if the param has already been created: */
	param=(Param*)this->FindParamObject(enum_type);

	if(param) param->SetValue(scalar); //already exists, just set it.
	else this->AddObject(new DoubleParam(enum_type,scalar)); //just add the new parameter.
}
/*}}}*/
/*FUNCTION Parameters::SetParam(char* string,int enum_type);{{{1*/
void   Parameters::SetParam(char* string,int enum_type){

	Param* param=NULL;
	
	/*first, figure out if the param has already been created: */
	param=(Param*)this->FindParamObject(enum_type);

	if(param) param->SetValue(string); //already exists, just set it.
	else this->AddObject(new StringParam(enum_type,string)); //just add the new parameter.
}
/*}}}*/
/*FUNCTION Parameters::SetParam(char** stringarray,int M, int enum_type);{{{1*/
void   Parameters::SetParam(char** stringarray,int M, int enum_type){

	Param* param=NULL;
	
	/*first, figure out if the param has already been created: */
	param=(Param*)this->FindParamObject(enum_type);

	if(param) param->SetValue(stringarray,M); //already exists, just set it.
	else this->AddObject(new StringArrayParam(enum_type,stringarray,M)); //just add the new parameter.
}
/*}}}*/
/*FUNCTION Parameters::SetParam(double* doublearray,int M,int enum_type);{{{1*/
void   Parameters::SetParam(double* doublearray,int M, int enum_type){

	Param* param=NULL;
	
	/*first, figure out if the param has already been created: */
	param=(Param*)this->FindParamObject(enum_type);

	if(param) param->SetValue(doublearray,M); //already exists, just set it.
	else this->AddObject(new DoubleVecParam(enum_type,doublearray,M)); //just add the new parameter.
}
/*}}}*/
/*FUNCTION Parameters::SetParam(double* doublearray,int M,int N, int enum_type);{{{1*/
void   Parameters::SetParam(double* doublearray,int M, int N, int enum_type){

	Param* param=NULL;
	
	/*first, figure out if the param has already been created: */
	param=(Param*)this->FindParamObject(enum_type);

	if(param) param->SetValue(doublearray,M,N); //already exists, just set it.
	else this->AddObject(new DoubleMatParam(enum_type,doublearray,M,N)); //just add the new parameter.
}
/*}}}*/
/*FUNCTION Parameters::SetParam(Vec vector,int enum_type);{{{1*/
void   Parameters::SetParam(Vec vector,int enum_type){

	Param* param=NULL;
	
	/*first, figure out if the param has already been created: */
	param=(Param*)this->FindParamObject(enum_type);

	if(param) param->SetValue(vector); //already exists, just set it.
	else this->AddObject(new PetscVecParam(enum_type,vector)); //just add the new parameter.
}
/*}}}*/
/*FUNCTION Parameters::SetParam(Mat matrix,int enum_type);{{{1*/
void   Parameters::SetParam(Mat matrix,int enum_type){

	Param* param=NULL;
	
	/*first, figure out if the param has already been created: */
	param=(Param*)this->FindParamObject(enum_type);

	if(param) param->SetValue(matrix); //already exists, just set it.
	else this->AddObject(new PetscMatParam(enum_type,matrix)); //just add the new parameter.
}
/*}}}*/

/*FUNCTION Parameters::FindParamObject{{{1*/
Object* Parameters::FindParamObject(int enum_type){

	/*Go through a dataset, and find a Param* object 
	 *which parameter name is "name" : */

	vector<Object*>::iterator object;
	Param* param=NULL;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Ok, this object is a parameter, recover it and ask which name it has: */
		param=(Param*)(*object);

		if(param->EnumType()==enum_type){
			/*Ok, this is the one! Return the object: */
			return (*object);
		}
	}
	return NULL;
}
/*}}}*/
