/*!\file: DakotaFree.cpp
 * \brief DakotaFree: free allocations on other cpus, not done by Dakota.

 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../DataSet/DataSet.h"    
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../modules.h"


void DakotaFree(double** pvariables,char*** pvariables_descriptors,char*** presponses_descriptors,int numvariables,int numresponses){

	int i;
	
	double* variables=NULL;
	char**  variables_descriptors=NULL;
	char**  responses_descriptors=NULL;
	char*   string=NULL;

	/*recover pointers: */
	variables=*pvariables;
	variables_descriptors=*pvariables_descriptors;
	responses_descriptors=*presponses_descriptors;


	/*Free variables and variables_descriptors only on cpu !=0*/
	if(my_rank!=0){
		xfree((void**)&variables);
		for(i=0;i<numvariables;i++){
			string=variables_descriptors[i];
			xfree((void**)&string);
		}
		xfree((void**)&variables_descriptors);
	}
	
	//responses descriptors on every cpu
	for(i=0;i<numresponses;i++){
		string=responses_descriptors[i];
		xfree((void**)&string);
	}
	//rest of dynamic allocations.
	xfree((void**)&responses_descriptors);

	/*Assign output pointers:*/
	*pvariables=variables;
	*pvariables_descriptors=variables_descriptors;
	*presponses_descriptors=responses_descriptors;
}

