function! AlignSection(regex) range
	let extra = 1
	let sep = empty(a:regex) ? '=' : a:regex
	let maxpos = 0
	let section = getline(a:firstline, a:lastline)
	for line in section
		let pos = match(line, ' *'.sep)
		if maxpos < pos
			let maxpos = pos
		endif
	endfor
	call map(section, 'AlignLine(v:val, sep, maxpos, extra)')
	call setline(a:firstline, section)
endfunction

function! AlignLine(line, sep, maxpos, extra)
	let m = matchlist(a:line, '\(.\{-}\) \{-}\('.a:sep.'.*\)')
	if empty(m)
		return a:line
	endif
	let spaces = repeat(' ', a:maxpos - strlen(m[1]) + a:extra)
	return m[1] . spaces . m[2]
endfunction
