/*!\file NodesDofx
 * \brief: establish degrees of freedom for all nodes
 */

#include "./NodesDofx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void NodesDofx(Nodes* nodes, Parameters* parameters,int analysis_type){

	int noerr=1;
	int found=0;
	int i;
	
	/*intermediary: */
	int  numberofnodes;
	int  numberofdofspernode;

	/*First, recover number nodes associated th this analysis: */
	numberofnodes=nodes->NumberOfNodes(analysis_type);

	/*Recover number of dofs per node: */
	found=parameters->FindParam(&numberofdofspernode,NumberOfDofsPerNodeEnum);
	if(!found)ISSMERROR("could not find numberofdofspernode in parameters");

	/*Ensure that only for each cpu, the partition border nodes only will be taken into account once 
	 * across the cluster. To do so, we flag all the clone nodes: */
	nodes->FlagClones(numberofnodes,analysis_type);

	/*Go through all nodes, and build degree of freedom lists. Each node gets a fixed number of dofs. When 
	 *a  node has already been distributed dofs on one cpu, all other cpus with the same node cannot distribute it 
	 *anymore. Use clone field to be sure of that: */
	nodes->DistributeDofs(numberofnodes,numberofdofspernode,analysis_type);

}
