#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=$1;

#version of vim
version=`echo *.tar.bz2 | sed 's/\.tar\.bz2//g' | sed 's/vim-//g'` #ex 7.2
version2=$(echo $version | sed -e "s/\.//g")  #ex: 72

#Some cleanup
rm -rf install src
rm -rf vim$version2

#Create src and install directories
mkdir install src

#Untar 
tar -zxvf  vim-$version.tar.bz2

#Move vim into install directory
mv vim$version2/* src
rm -rf vim$version2

#Configure doxygen
cd src/src && ./configure --prefix "$ISSM_DIR/externalpackages/vim/install"

#Compile vim
if [ -z $NUMCPUS ];
then
	make
else
	make -j $NUMCPUS
fi

#Install vim
make  install
