function femmodel=SetCurrentAnalysis(femmodel,analysis_enum)
%SETCURRENTANALYSIS - set current analysis used to configure elements and nodes in our solutions
%
%   Usage:
%      femmodel=SetCurrentAnalysis(femmodel,analysis_type)
%
%   Ex:
%      femmodel=SetCurrentAnalysis(femmodel,DiagnosticHorizAnalysisEnum)
%


	%first, look for analysis: 
	found=-1;
	for i=1:length(femmodel.analysis_type_list),
		if femmodel.analysis_type_list(i)==analysis_enum,
			found=i;
			break;
		end
	end

	if found==-1,
		error('SetCurrentAnalysis error message: could not find analysis_type in list of FemModel analyses');
	end
	
	%activate matrices and vectors: 
	femmodel.Rmg=femmodel.m_Rmg{found};
	femmodel.Gmn=femmodel.m_Gmn{found};
	femmodel.nodesets=femmodel.m_nodesets{found};
	femmodel.yg=femmodel.m_yg{found};
	femmodel.ys=femmodel.m_ys{found};

	%Now, plug analysis_counter and analysis_type inside the parameters: 
	%set counter and analyse_type
	femmodel.parameters.AnalysisCounter=found-1; %for c indices
	femmodel.parameters.AnalysisType=analysis_enum;
