function femmodel=transient2d_core(femmodel)
%TRANSIENT2D_CORE - core of transient 2d solution
%
%   Usage:
%      femmodel=transient2d_core(femmodel)

	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;
	ndt=femmodel.parameters.Ndt;
	dt=femmodel.parameters.Dt;

	%Initialize
	time=0;
	step=0;

	%Loop through time
	while time<ndt,
		displaystring(verbose,'\n%s%g%s%i%s%g\n','time [yr]',time,'iteration number: ',step,'/',floor(ndt/dt));
		step=step+1;
		time=time+dt;

		displaystring(verbose,'\n%s',['computing new velocities...']);
		femmodel=diagnostic_core(femmodel); 

		displaystring(verbose,'\n%s',['computing new thickness...']);
		femmodel=prognostic_core(femmodel); 

		displaystring(verbose,'\n%s',['updating geometry...']);
		[femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=UpdateGeometry(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);

		displaystring(verbose,'\n%s',['saving results...']);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VxEnum,step,time);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VyEnum,step,time);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,PressureEnum,step,time);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,ThicknessEnum,step,time);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,SurfaceEnum,step,time);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,BedEnum,step,time);
	end

end %end of function
