function femmodel=steadystate_core(femmodel);
%STEADYSTATE_CORE - compute the core temperature and velocity field  at thermal steady state.
%
%   Usage:
%      femmodel=steadystate_core(femmodel);
%

	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;
	dim=femmodel.parameters.Dim;

	%Initialize counter
	step=1;

	while true,

		displaystring(verbose,'\n%s%i/\n','computing velocities and temperatures for step: ',step);
		femmodel=thermal_core(femmodel); 

		displaystring(verbose,'\n%s',['computing depth average temperature...']);
		[femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=InputDepthAverage(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,TemperatureEnum,TemperatureAverageEnum);

		displaystring(verbose,'\n%s',['computing new velocity...']);
		femmodel=diagnostic_core(femmodel); 

		displaystring(verbose,'\n%s',['checking temperature, velocity and pressure convergence...']);
		if step>1,
			if steadystateconvergence(femmodel),
				break;
			end
		end 

		displaystring(verbose,'\n%s',['saving velocities, temperature and pressure for convergence...']);
		femmodel.elements=InputDuplicate(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VxEnum,VxOldEnum);
		femmodel.elements=InputDuplicate(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VyEnum,VyOldEnum);
		femmodel.elements=InputDuplicate(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VzEnum,VzOldEnum);
		femmodel.elements=InputDuplicate(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,PressureEnum,PressureOlddnum);
		femmodel.elements=InputDuplicate(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,TemperatureEnum,TemperatureOldEnum);

		%Increase counter
		step=step+1;

	end

	displaystring(verbose,'\n%s',['saving results...']);
	femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VxEnum);
	femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VyEnum);
	femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VzEnum);
	femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,PressureEnum);
	femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,TemperatureEnum);
	end

end %end of function
