function femmodel=balancedvelocities_core(femmdoel)
%BALANCEDVELOCITIES_CORE - linear solution sequence
%
%   Usage:
%      femmodel=balancedvelocities_core(femmodel)

	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;
	dim=femmodel.parameters.Dim;

	%Activate formulation
	femmodel=SetCurrentAnalysis(femmodel,BalancedvelocitiesAnalysisEnum);

	displaystring(verbose,'\n%s',['depth averaging velocities...']);
	[femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=InputDepthAverage(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VxEnum,VxAverageEnum);
	[femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=InputDepthAverage(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VyEnum,VyAverageEnum);
	if dim==3,
		[femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=InputDepthAverage(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VzEnum,VzAverageEnum);
	end

	displaystring(verbose,'\n%s',['call computational core...']);
	femmodel=solver_linear(femmodel);
	
	displaystring(verbose,'\n%s',['extude computed thickness on all layers...']);
	femmodel.elements=InputExtrude(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VxEnum);
	femmodel.elements=InputExtrude(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VyEnum);

	displaystring(verbose,'\n%s',['saving results...']);
	femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VxEnum);
	femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VyEnum);

end %end function
