/*
 * \file Loads.c
 * \brief: implementation of the Loads class, derived from DataSet class
 */

/*Headers: {{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <vector>
#include <functional>
#include <algorithm>
#include <iostream>

#include "./DataSet.h"
#include "../shared/shared.h"
#include "../include/include.h"
#include "../EnumDefinitions/EnumDefinitions.h"

using namespace std;
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION Loads::Loads(){{{1*/
Loads::Loads(){
	return;
}
/*}}}*/
/*FUNCTION Loads::Loads(int in_enum){{{1*/
Loads::Loads(int in_enum): DataSet(in_enum){
	//do nothing;
	return;
}
/*}}}*/
/*FUNCTION Loads::~Loads(){{{1*/
Loads::~Loads(){
	return;
}
/*}}}*/

/*Numerics:*/
/*FUNCTION Loads::MeltingIsPresent{{{1*/
int   Loads::MeltingIsPresent(){

	int i;
	int found=0;
	int mpi_found=0;

	for(i=0;i<this->Size();i++){
		Object* object=(Object*)this->GetObjectByOffset(i);
		if (object->Enum()==PengridEnum){
			found=1;
			break;
		}
	}
	
	#ifdef _PARALLEL_
	MPI_Reduce (&found,&mpi_found,1,MPI_INT,MPI_SUM,0,MPI_COMM_WORLD );
	MPI_Bcast(&mpi_found,1,MPI_INT,0,MPI_COMM_WORLD);                
	found=mpi_found;
	#endif

	return found;
}
/*}}}*/
/*FUNCTION Loads::MeltingConstraints{{{1*/
void  Loads::MeltingConstraints(int* pconverged, int* pnum_unstable_constraints){

	int i;

	int unstable=0;
	int num_unstable_constraints=0;
	int converged=0;
	int sum_num_unstable_constraints=0;

	num_unstable_constraints=0;	

	/*Enforce constraints: */
	for(i=0;i<this->Size();i++){
		Object* object=(Object*)this->GetObjectByOffset(i);
		if(object->Enum()==PengridEnum){

			Pengrid* pengrid=(Pengrid*)object;
			pengrid->PenaltyConstrain(&unstable);
			num_unstable_constraints+=unstable;
		}
	}

	#ifdef _PARALLEL_
	MPI_Reduce (&num_unstable_constraints,&sum_num_unstable_constraints,1,MPI_INT,MPI_SUM,0,MPI_COMM_WORLD );
	MPI_Bcast(&sum_num_unstable_constraints,1,MPI_INT,0,MPI_COMM_WORLD);                
	num_unstable_constraints=sum_num_unstable_constraints;
	#endif

	/*Have we converged? : */
	if (num_unstable_constraints==0) converged=1;
	else converged=0;

	/*Assign output pointers: */
	*pconverged=converged;
	*pnum_unstable_constraints=num_unstable_constraints;
}
/*}}}*/
