/*
 * \file Constraints.c
 * \brief: implementation of the Constraints class, derived from DataSet class
 */

/*Headers: {{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <vector>
#include <functional>
#include <algorithm>
#include <iostream>

#include "./DataSet.h"
#include "../shared/shared.h"
#include "../include/include.h"
#include "../EnumDefinitions/EnumDefinitions.h"

using namespace std;
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION Constraints::Constraints(){{{1*/
Constraints::Constraints(){
	return;
}
/*}}}*/
/*FUNCTION Constraints::Constraints(int in_enum){{{1*/
Constraints::Constraints(int in_enum): DataSet(in_enum){
	//do nothing;
	return;
}
/*}}}*/
/*FUNCTION Constraints::~Constraints(){{{1*/
Constraints::~Constraints(){
	return;
}
/*}}}*/

/*Numerics: */
/*FUNCTION Constraints::NumberOfLocalRgbs{{{1*/
int   Constraints::NumberOfLocalRgbs(int analysis_type){

	int i;
	int  count=0;

	for(i=0;i<this->Size();i++){

		Object* object=(Object*)this->GetObjectByOffset(i);

		/*Check this is a single point constraint (spc): */
		if (object->Enum()==RgbEnum){

			Rgb* rgb=(Rgb*)object;
			if(rgb->InAnalysis(analysis_type))count++;
		}
	}

	return count;
}
/*}}}*/

