/*\file PenaltyConstraints.c
 *\brief: set up penalty constraints
 */

#include "./PenaltyConstraints.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;

	/*output: */
	int converged;
	int num_unstable_constraints;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&PenaltyConstraintsUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADSIN);
	FetchData((DataSet**)&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);

	/*!Generate internal degree of freedom numbers: */
	PenaltyConstraintsx(&converged, &num_unstable_constraints, elements,nodes,vertices, loads,materials,parameters);

	/*write output datasets: */
	WriteData(LOADS,loads);
	WriteData(CONVERGED,converged);
	WriteData(NUMUNSTABLECONSTRAINTS,num_unstable_constraints);
	
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void PenaltyConstraintsUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [loads, constraints_converged, num_unstable_constraints] = %s(elements,nodes,vertices,loads,materials,params);\n",__FUNCT__);
	_printf_("\n");
}
