/*\file MassFlux.c
 *\brief: compute mass flux along a profile.
 */

#include "./MassFlux.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;

	double*  segments=NULL;
	int      num_segments;

	/* output datasets: */
	double   mass_flux;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&MassFluxUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADS);
	FetchData((DataSet**)&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	parameters->FindParam(&segments,&num_segments,NULL,QmuMassFluxSegmentsEnum);

	/*!Compute mass flux along the profile: */
	MassFluxx(&mass_flux, elements,nodes,vertices,loads,materials,parameters,segments,num_segments);


	/*write output datasets: */
	WriteData(RESPONSE,mass_flux);
	
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void MassFluxUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [mass_flux] = %s(elements,nodes,vertices,loads,materials,parameters);\n",__FUNCT__);
	_printf_("\n");
}
