/*\file ComputeBasalStress.c
 *\brief: recover pressure from elements
 */

#include "./ComputeBasalStress.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL; 
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;
	int      numberofnodes;
	int      analysis_type;
	int      sub_analysis_type;

	/* output datasets: */
	Vec sigma_g=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ComputeBasalStressUsage);
        
	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADS);
	FetchData((DataSet**)&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	FetchData(&analysis_type,ANALYSIS);
	FetchData(&sub_analysis_type,SUBANALYSIS);

	/*!Generate internal degree of freedom numbers: */
	ComputeBasalStressx(&sigma_g, elements,nodes,vertices,loads,materials,parameters,analysis_type,sub_analysis_type);

	/*write output datasets: */
	WriteData(SIGMA,sigma_g);

	/*Free ressources: */
	delete nodes;
	delete vertices;
	delete elements;
	delete materials;
	delete loads;
	delete parameters;
	VecFree(&sigma_g);

	/*end module: */
	MODULEEND();
}

void ComputeBasalStressUsage(void) {
	printf("\n");
	printf("   usage: [p_g] = %s(elements, nodes, vertices, loads, materials, params);\n",__FUNCT__);
	printf("\n");
}
