/*!\file Numericalflux.h
 * \brief: header file for icefront object
 */

#ifndef _NUMERICALFLUX_H_
#define _NUMERICALFLUX_H_

/*Headers:*/
/*{{{1*/
#include "./Load.h"
class Hook;
class Parameters;
class Inputs;
class IoModel;

/*}}}*/

class Numericalflux: public Load {

	public: 
		int         id;
		int analysis_type;

		Hook        helements;
		Hook        hnodes;
		Parameters *parameters;
		Inputs     *inputs;


		/*Constructors {{{1*/
		Numericalflux();
		Numericalflux(int numericalflux_id,int i, IoModel* iomodel,int analysis_type);
		~Numericalflux();
		Object* copy();
		/*}}}*/
		/*Object management: {{{1*/
		void  Configure(Elements* elements,Loads* loads,DataSet* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void    InputUpdateFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromSolution(double* solution){ISSMERROR("Not implemented yet!");}
		bool    InAnalysis(int analysis_type);

		/*}}}*/
		/*Numerics: {{{1*/
		void  GetJacobianDeterminant(double* pJdet,double xyz_list[4][3], double gauss_coord);
		void  GetNodalFunctions(double* l1l4, double gauss_coord);
		void  GetB(double* B, double gauss_coord);
		void  GetL(double* L, double gauss_coord,int numdof);
		void  GetDofList(int* doflist,int* pnumberofdofs);
		void  GetNormal(double* normal,double xyz_list[4][3]);
		void  GetParameterValue(double* pp, double* plist, double gauss_coord);
		void  UpdateFromInputs(void* inputs);
		
		void  CreateKMatrix(Mat Kgg);
		void  CreateKMatrixInternal(Mat Kgg);
		void  CreateKMatrixBoundary(Mat Kgg);
		void  CreatePVector(Vec pg);
		void  CreatePVectorInternal(Vec pg);
		void  CreatePVectorBoundary(Vec pg);
		void  PenaltyCreateKMatrix(Mat Kgg,double kmax);
		void  PenaltyCreatePVector(Vec pg,double kmax);
		/*}}}*/

};

#endif  /* _NUMERICALFLUX_H_ */
