/*!\file Icefront.h
 * \brief: header file for icefront object
 */

#ifndef _ICEFRONT_H_
#define _ICEFRONT_H_

/*Headers:*/
/*{{{1*/
#include "./Load.h"
class Hook;
class Inputs;
class Parameters;
class IoModel;

#define MAX_ICEFRONT_GRIDS 4 //max number of grids for a certain load
#define ICEFRONTSTRING 20 //max string length
/*}}}*/

class Icefront: public Load {

	public:
		int id;
		int analysis_type;

		/*hooks: */
		Hook hnodes;
		Hook helement;
		Hook hmatpar;

		/*inputs and parameters: */
		Inputs* inputs;
		Parameters* parameters;

		/*constructors: {{{1*/
		Icefront();
		Icefront(int icefront_id,int i, IoModel* iomodel,int analysis_type);
		~Icefront();
		Object* copy();
		/*}}}*/
		/*object management: {{{1*/
		void  Configure(Elements* elementsin,Loads* loadsin,DataSet* nodesin,Vertices* verticesin,Materials* materialsin,Parameters* parametersin);
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void  InputUpdateFromVector(double* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromSolution(double* solution);
		bool  InAnalysis(int analysis_type);
		/*}}}*/
		/*numerics: {{{1*/
		void  CreateKMatrix(Mat Kgg);
		void  CreatePVector(Vec pg);
		void  CreatePVectorDiagnosticHoriz( Vec pg);
		void  CreatePVectorDiagnosticHorizSegment( Vec pg);
		void  CreatePVectorDiagnosticHorizQuad( Vec pg);
		void  CreatePVectorDiagnosticStokes( Vec pg);
		void  GetDofList(int* doflist,int* pnumberofdofs);
		void  SegmentPressureLoad(double* pe_g,double rho_water,double rho_ice,double gravity, double* thickness_list, double* bed_list, double* normal,double length);
		void  QuadPressureLoad(double* pe_g,double rho_water,double rho_ice,double gravity, double* thickness_list, double* bed_list, 
		                              double* normal1,double* normal2,double* normal3,double* normal4,double* xyz_list);
		void  QuadPressureLoadStokes(double* pe_g,double rho_water,double rho_ice,double gravity, double* thickness_list, double* bed_list, 
		                              double* normal1,double* normal2,double* normal3,double* normal4,double* xyz_list);
		void  PenaltyCreateKMatrix(Mat Kgg,double kmax);
		void  PenaltyCreatePVector(Vec pg,double kmax);
		/*}}}*/
};

#endif  /* _ICEFRONT_H_ */
