/*!\file SystemMatricesx
 * \brief: create system matrices (stiffness matrix, loads vector)
 */

#include "./SystemMatricesx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void SystemMatricesx(Mat* pKgg, Vec* ppg,Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads,Materials* materials, Parameters* parameters, int kflag,int pflag){
	
	/*intermediary: */
	int gsize;
	int i,j;
	int connectivity;
	int numberofdofspernode;
	Element* element=NULL;
	Load*    load=NULL;
	
	/*output: */
	Mat Kgg=NULL;
	Vec pg=NULL;

	int analysis_type;

	/*First, get elements and loads configured: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*retrive parameters: */
	parameters->FindParam(&analysis_type,AnalysisTypeEnum);

	/*Recover parameters: */
	parameters->FindParam(&connectivity,ConnectivityEnum);
	parameters->FindParam(&numberofdofspernode,NumberOfDofsPerNodeEnum);

	/*Get size of matrix: */
	gsize=nodes->NumberOfDofs(analysis_type);

	/*Compute stiffness matrix*/
	if(kflag){

		/*Allocate Kgg*/
		Kgg=NewMat(gsize,gsize,NULL,&connectivity,&numberofdofspernode);

		/*Fill stiffness matrix from elements: */
		for (i=0;i<elements->Size();i++){
			element=(Element*)elements->GetObjectByOffset(i);
			element->CreateKMatrix(Kgg);
		}

		/*Fill stiffness matrix from loads: */
		for (i=0;i<loads->Size();i++){
			load=(Load*)loads->GetObjectByOffset(i);
			load->CreateKMatrix(Kgg);
		}

		/*Assemble matrix and compress matrix to save memory: */
		MatAssemblyBegin(Kgg,MAT_FINAL_ASSEMBLY);
		MatAssemblyEnd(Kgg,MAT_FINAL_ASSEMBLY);
		MatCompress(Kgg);
	}

	/*Compute Load vector*/
	if(pflag){

		/*Allocate pg*/
		pg=NewVec(gsize);

		/*Fill right hand side vector, from elements: */
		for (i=0;i<elements->Size();i++){
			element=(Element*)elements->GetObjectByOffset(i);
			element->CreatePVector(pg);
		}

		/*Fill right hand side vector, from loads: */
		for (i=0;i<loads->Size();i++){
			load=(Load*)loads->GetObjectByOffset(i);
			load->CreatePVector(pg);
		}

		/*Assemble right hand side: */
		VecAssemblyBegin(pg);
		VecAssemblyEnd(pg);
	}
	
	/*Assign output pointers: */
	*pKgg=Kgg;
	*ppg=pg;

}
