/*\file Du.c
 *\brief: compute diff between observed and modeled velocity
 */

#include "./Du.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;

	/* output datasets: */
	Vec du_g=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&DuUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADS);
	FetchData((DataSet**)&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);

	/*!Call core code: */
	Dux(&du_g, elements,nodes,vertices, loads,materials,parameters);

	/*write output : */
	WriteData(DUG,du_g);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	VecFree(&du_g);

	/*end module: */
	MODULEEND();
}

void DuUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [du_g] = %s(lements,nodes,vertices,loads,materials, parameters);\n",__FUNCT__);
	_printf_("\n");
}
